/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.md.sal.binding.impl;

import com.google.common.collect.ClassToInstanceMap;
import com.google.common.collect.ImmutableSet;
import java.util.Set;
import org.opendaylight.controller.md.sal.binding.api.BindingTransactionChain;
import org.opendaylight.controller.md.sal.binding.api.DataBroker;
import org.opendaylight.controller.md.sal.binding.api.DataTreeChangeListener;
import org.opendaylight.controller.md.sal.binding.api.DataTreeChangeService;
import org.opendaylight.controller.md.sal.binding.api.DataTreeIdentifier;
import org.opendaylight.controller.md.sal.binding.api.ReadOnlyTransaction;
import org.opendaylight.controller.md.sal.binding.api.ReadWriteTransaction;
import org.opendaylight.controller.md.sal.binding.api.WriteTransaction;
import org.opendaylight.controller.md.sal.binding.impl.AbstractForwardedDataBroker;
import org.opendaylight.controller.md.sal.binding.impl.BindingDOMAdapterBuilder;
import org.opendaylight.controller.md.sal.binding.impl.BindingDOMDataTreeChangeServiceAdapter;
import org.opendaylight.controller.md.sal.binding.impl.BindingDOMReadTransactionAdapter;
import org.opendaylight.controller.md.sal.binding.impl.BindingDOMReadWriteTransactionAdapter;
import org.opendaylight.controller.md.sal.binding.impl.BindingDOMTransactionChainAdapter;
import org.opendaylight.controller.md.sal.binding.impl.BindingDOMWriteTransactionAdapter;
import org.opendaylight.controller.md.sal.binding.impl.BindingToNormalizedNodeCodec;
import org.opendaylight.controller.md.sal.common.api.data.TransactionChainListener;
import org.opendaylight.controller.md.sal.dom.api.DOMDataBroker;
import org.opendaylight.controller.md.sal.dom.api.DOMDataTreeChangeService;
import org.opendaylight.controller.md.sal.dom.api.DOMDataWriteTransaction;
import org.opendaylight.controller.md.sal.dom.api.DOMService;
import org.opendaylight.yangtools.concepts.ListenerRegistration;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class BindingDOMDataBrokerAdapter
extends AbstractForwardedDataBroker
implements DataBroker,
DataTreeChangeService {
    static final BindingDOMAdapterBuilder.Factory<DataBroker> BUILDER_FACTORY = () -> new Builder();
    private final DataTreeChangeService treeChangeService;

    public BindingDOMDataBrokerAdapter(DOMDataBroker domDataBroker, BindingToNormalizedNodeCodec codec) {
        super(domDataBroker, codec);
        DOMDataTreeChangeService domTreeChange = (DOMDataTreeChangeService)domDataBroker.getSupportedExtensions().get(DOMDataTreeChangeService.class);
        this.treeChangeService = domTreeChange != null ? BindingDOMDataTreeChangeServiceAdapter.create(codec, domTreeChange) : null;
    }

    public ReadOnlyTransaction newReadOnlyTransaction() {
        return new BindingDOMReadTransactionAdapter(this.getDelegate().newReadOnlyTransaction(), this.getCodec());
    }

    public ReadWriteTransaction newReadWriteTransaction() {
        return new BindingDOMReadWriteTransactionAdapter(this.getDelegate().newReadWriteTransaction(), this.getCodec());
    }

    public WriteTransaction newWriteOnlyTransaction() {
        return new BindingDOMWriteTransactionAdapter<DOMDataWriteTransaction>(this.getDelegate().newWriteOnlyTransaction(), this.getCodec());
    }

    public BindingTransactionChain createTransactionChain(TransactionChainListener listener) {
        return new BindingDOMTransactionChainAdapter(this.getDelegate(), this.getCodec(), listener);
    }

    public String toString() {
        return "BindingDOMDataBrokerAdapter for " + this.getDelegate();
    }

    public <T extends DataObject, L extends DataTreeChangeListener<T>> ListenerRegistration<L> registerDataTreeChangeListener(DataTreeIdentifier<T> treeId, L listener) {
        if (this.treeChangeService == null) {
            throw new UnsupportedOperationException("Underlying data broker does not expose DOMDataTreeChangeService.");
        }
        return this.treeChangeService.registerDataTreeChangeListener(treeId, listener);
    }

    private static class Builder
    extends BindingDOMAdapterBuilder<DataBroker> {
        private Builder() {
        }

        @Override
        public Set<? extends Class<? extends DOMService>> getRequiredDelegates() {
            return ImmutableSet.of(DOMDataBroker.class);
        }

        @Override
        protected DataBroker createInstance(BindingToNormalizedNodeCodec codec, ClassToInstanceMap<DOMService> delegates) {
            DOMDataBroker domDataBroker = (DOMDataBroker)delegates.getInstance(DOMDataBroker.class);
            return new BindingDOMDataBrokerAdapter(domDataBroker, codec);
        }
    }
}

