/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.md.sal.binding.impl;

import com.google.common.base.Preconditions;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ClassToInstanceMap;
import com.google.common.collect.ImmutableSet;
import java.util.Set;
import org.opendaylight.controller.md.sal.binding.impl.BindingDOMAdapterBuilder;
import org.opendaylight.controller.md.sal.binding.impl.BindingToNormalizedNodeCodec;
import org.opendaylight.controller.md.sal.binding.impl.RpcServiceAdapter;
import org.opendaylight.controller.md.sal.dom.api.DOMRpcService;
import org.opendaylight.controller.md.sal.dom.api.DOMService;
import org.opendaylight.controller.sal.binding.api.RpcConsumerRegistry;
import org.opendaylight.yangtools.yang.binding.RpcService;
import org.opendaylight.yangtools.yang.binding.util.BindingReflections;

public class BindingDOMRpcServiceAdapter
implements RpcConsumerRegistry {
    protected static final BindingDOMAdapterBuilder.Factory<RpcConsumerRegistry> BUILDER_FACTORY = new BindingDOMAdapterBuilder.Factory<RpcConsumerRegistry>(){

        @Override
        public BindingDOMAdapterBuilder<RpcConsumerRegistry> newBuilder() {
            return new Builder();
        }
    };
    private final LoadingCache<Class<? extends RpcService>, RpcServiceAdapter> proxies = CacheBuilder.newBuilder().weakKeys().build((CacheLoader)new CacheLoader<Class<? extends RpcService>, RpcServiceAdapter>(){

        public RpcServiceAdapter load(Class<? extends RpcService> key) throws Exception {
            return BindingDOMRpcServiceAdapter.this.createProxy(key);
        }
    });
    private final DOMRpcService domService;
    private final BindingToNormalizedNodeCodec codec;

    public BindingDOMRpcServiceAdapter(DOMRpcService domService, BindingToNormalizedNodeCodec codec) {
        this.domService = domService;
        this.codec = codec;
    }

    public <T extends RpcService> T getRpcService(Class<T> rpcService) {
        Preconditions.checkArgument((rpcService != null ? 1 : 0) != 0, (Object)"Rpc Service needs to be specied.");
        return (T)((RpcServiceAdapter)this.proxies.getUnchecked(rpcService)).getProxy();
    }

    private RpcServiceAdapter createProxy(Class<? extends RpcService> key) {
        Preconditions.checkArgument((boolean)BindingReflections.isBindingClass(key));
        Preconditions.checkArgument((boolean)key.isInterface(), (Object)"Supplied RPC service type must be interface.");
        return new RpcServiceAdapter(key, this.codec, this.domService);
    }

    private static final class Builder
    extends BindingDOMAdapterBuilder<RpcConsumerRegistry> {
        private Builder() {
        }

        @Override
        protected RpcConsumerRegistry createInstance(BindingToNormalizedNodeCodec codec, ClassToInstanceMap<DOMService> delegates) {
            DOMRpcService domRpc = (DOMRpcService)delegates.getInstance(DOMRpcService.class);
            return new BindingDOMRpcServiceAdapter(domRpc, codec);
        }

        @Override
        public Set<? extends Class<? extends DOMService>> getRequiredDelegates() {
            return ImmutableSet.of(DOMRpcService.class);
        }
    }
}

