/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.md.sal.binding.impl;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.util.concurrent.CheckedFuture;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.opendaylight.controller.md.sal.dom.api.DOMRpcException;
import org.opendaylight.controller.md.sal.dom.api.DOMRpcResult;
import org.opendaylight.controller.md.sal.dom.spi.DefaultDOMRpcResult;
import org.opendaylight.mdsal.binding.dom.codec.api.BindingNormalizedNodeSerializer;
import org.opendaylight.yangtools.yang.binding.DataContainer;
import org.opendaylight.yangtools.yang.common.RpcResult;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;

final class LazyDOMRpcResultFuture
implements CheckedFuture<DOMRpcResult, DOMRpcException> {
    private final ListenableFuture<RpcResult<?>> bindingFuture;
    private final BindingNormalizedNodeSerializer codec;
    private volatile DOMRpcResult result;

    private LazyDOMRpcResultFuture(ListenableFuture<RpcResult<?>> delegate, BindingNormalizedNodeSerializer codec) {
        this.bindingFuture = (ListenableFuture)Preconditions.checkNotNull(delegate, (Object)"delegate");
        this.codec = (BindingNormalizedNodeSerializer)Preconditions.checkNotNull((Object)codec, (Object)"codec");
    }

    static CheckedFuture<DOMRpcResult, DOMRpcException> create(BindingNormalizedNodeSerializer codec, ListenableFuture<RpcResult<?>> bindingResult) {
        return new LazyDOMRpcResultFuture(bindingResult, codec);
    }

    ListenableFuture<RpcResult<?>> getBindingFuture() {
        return this.bindingFuture;
    }

    public boolean cancel(boolean mayInterruptIfRunning) {
        return this.bindingFuture.cancel(mayInterruptIfRunning);
    }

    public void addListener(Runnable listener, Executor executor) {
        this.bindingFuture.addListener(listener, executor);
    }

    public DOMRpcResult get() throws InterruptedException, ExecutionException {
        if (this.result != null) {
            return this.result;
        }
        return this.transformIfNecessary((RpcResult)this.bindingFuture.get());
    }

    public DOMRpcResult get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        if (this.result != null) {
            return this.result;
        }
        return this.transformIfNecessary((RpcResult)this.bindingFuture.get(timeout, unit));
    }

    public DOMRpcResult checkedGet() throws DOMRpcException {
        try {
            return this.get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public DOMRpcResult checkedGet(long timeout, TimeUnit unit) throws TimeoutException, DOMRpcException {
        try {
            return this.get(timeout, unit);
        }
        catch (InterruptedException | ExecutionException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public boolean isCancelled() {
        return this.bindingFuture.isCancelled();
    }

    public boolean isDone() {
        return this.bindingFuture.isDone();
    }

    private synchronized DOMRpcResult transformIfNecessary(RpcResult<?> input) {
        if (this.result == null) {
            this.result = this.transform(input);
        }
        return this.result;
    }

    private DOMRpcResult transform(RpcResult<?> input) {
        if (input.isSuccessful()) {
            Object inputData = input.getResult();
            if (inputData instanceof DataContainer) {
                return new DefaultDOMRpcResult((NormalizedNode)this.codec.toNormalizedNodeRpcData((DataContainer)inputData));
            }
            return new DefaultDOMRpcResult((NormalizedNode)null);
        }
        return new DefaultDOMRpcResult(input.getErrors());
    }
}

