/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.md.sal.binding.spi;

import com.google.common.base.Preconditions;
import com.google.common.collect.ClassToInstanceMap;
import com.google.common.collect.ImmutableClassToInstanceMap;
import com.google.common.collect.MutableClassToInstanceMap;
import java.util.Set;
import org.opendaylight.yangtools.concepts.Builder;

public abstract class AdapterBuilder<T, D>
implements Builder<T> {
    private final ClassToInstanceMap<D> delegates = MutableClassToInstanceMap.create();

    public abstract Set<? extends Class<? extends D>> getRequiredDelegates();

    protected abstract T createInstance(ClassToInstanceMap<D> var1);

    private void checkAllRequiredServices() {
        for (Class<D> type : this.getRequiredDelegates()) {
            Preconditions.checkState((this.delegates.get(type) != null ? 1 : 0) != 0, (String)"Requires service %s is not defined.", (Object[])new Object[]{type});
        }
    }

    public final <V extends D> void addDelegate(Class<V> type, D impl) {
        this.delegates.put(type, impl);
    }

    public final T build() {
        this.checkAllRequiredServices();
        return this.createInstance((ClassToInstanceMap<D>)ImmutableClassToInstanceMap.copyOf(this.delegates));
    }
}

