/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.md.sal.binding.impl;

import com.google.common.base.Preconditions;
import java.util.Collection;
import org.opendaylight.controller.md.sal.binding.api.DataTreeChangeListener;
import org.opendaylight.controller.md.sal.binding.impl.BindingToNormalizedNodeCodec;
import org.opendaylight.controller.md.sal.binding.impl.LazyDataTreeModification;
import org.opendaylight.controller.md.sal.common.api.data.LogicalDatastoreType;
import org.opendaylight.controller.md.sal.dom.api.DOMDataTreeChangeListener;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.data.api.schema.tree.DataTreeCandidate;

class BindingDOMDataTreeChangeListenerAdapter<T extends DataObject>
implements DOMDataTreeChangeListener {
    private final BindingToNormalizedNodeCodec codec;
    private final DataTreeChangeListener<T> listener;
    private final LogicalDatastoreType store;

    BindingDOMDataTreeChangeListenerAdapter(BindingToNormalizedNodeCodec codec, DataTreeChangeListener<T> listener, LogicalDatastoreType store) {
        this.codec = (BindingToNormalizedNodeCodec)Preconditions.checkNotNull((Object)codec);
        this.listener = (DataTreeChangeListener)Preconditions.checkNotNull(listener);
        this.store = (LogicalDatastoreType)Preconditions.checkNotNull((Object)store);
    }

    public void onDataTreeChanged(Collection<DataTreeCandidate> domChanges) {
        Collection bindingChanges = LazyDataTreeModification.from(this.codec, domChanges, this.store);
        this.listener.onDataTreeChanged(bindingChanges);
    }

    public String toString() {
        return this.listener.toString();
    }
}

