/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.md.sal.binding.impl;

import com.google.common.util.concurrent.CheckedFuture;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.ArrayList;
import org.opendaylight.controller.md.sal.binding.api.WriteTransaction;
import org.opendaylight.controller.md.sal.binding.impl.AbstractWriteTransaction;
import org.opendaylight.controller.md.sal.binding.impl.BindingToNormalizedNodeCodec;
import org.opendaylight.controller.md.sal.common.api.TransactionStatus;
import org.opendaylight.controller.md.sal.common.api.data.LogicalDatastoreType;
import org.opendaylight.controller.md.sal.common.api.data.TransactionCommitFailedException;
import org.opendaylight.controller.md.sal.common.impl.service.AbstractDataTransaction;
import org.opendaylight.controller.md.sal.common.impl.util.compat.DataNormalizationException;
import org.opendaylight.controller.md.sal.common.impl.util.compat.DataNormalizationOperation;
import org.opendaylight.controller.md.sal.dom.api.DOMDataWriteTransaction;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;
import org.opendaylight.yangtools.yang.common.RpcResult;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;

class BindingDOMWriteTransactionAdapter<T extends DOMDataWriteTransaction>
extends AbstractWriteTransaction<T>
implements WriteTransaction {
    protected BindingDOMWriteTransactionAdapter(T delegateTx, BindingToNormalizedNodeCodec codec) {
        super(delegateTx, codec);
    }

    public <U extends DataObject> void put(LogicalDatastoreType store, InstanceIdentifier<U> path, U data) {
        this.put(store, path, data, false);
    }

    public <D extends DataObject> void merge(LogicalDatastoreType store, InstanceIdentifier<D> path, D data) {
        this.merge(store, path, data, false);
    }

    @Override
    protected void ensureParentsByMerge(LogicalDatastoreType store, YangInstanceIdentifier normalizedPath, InstanceIdentifier<?> path) {
        ArrayList<YangInstanceIdentifier.PathArgument> currentArguments = new ArrayList<YangInstanceIdentifier.PathArgument>();
        DataNormalizationOperation currentOp = this.getCodec().getDataNormalizer().getRootOperation();
        for (YangInstanceIdentifier.PathArgument currentArg : normalizedPath.getPathArguments()) {
            try {
                currentOp = currentOp.getChild(currentArg);
            }
            catch (DataNormalizationException e) {
                throw new IllegalArgumentException(String.format("Invalid child encountered in path %s", path), e);
            }
            currentArguments.add(currentArg);
            YangInstanceIdentifier currentPath = YangInstanceIdentifier.create(currentArguments);
            ((DOMDataWriteTransaction)this.getDelegate()).merge(store, currentPath, currentOp.createDefault(currentArg));
        }
    }

    public void delete(LogicalDatastoreType store, InstanceIdentifier<?> path) {
        this.doDelete(store, path);
    }

    public ListenableFuture<RpcResult<TransactionStatus>> commit() {
        return AbstractDataTransaction.convertToLegacyCommitFuture(this.submit());
    }

    public CheckedFuture<Void, TransactionCommitFailedException> submit() {
        return this.doSubmit();
    }

    public boolean cancel() {
        return this.doCancel();
    }
}

