/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.md.sal.binding.impl;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableBiMap;
import java.lang.reflect.Method;
import java.net.URI;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import org.opendaylight.controller.md.sal.binding.impl.FutureSchema;
import org.opendaylight.controller.md.sal.common.impl.util.compat.DataNormalizationException;
import org.opendaylight.controller.md.sal.common.impl.util.compat.DataNormalizationOperation;
import org.opendaylight.controller.md.sal.common.impl.util.compat.DataNormalizer;
import org.opendaylight.mdsal.binding.dom.codec.api.BindingCodecTree;
import org.opendaylight.mdsal.binding.dom.codec.api.BindingCodecTreeFactory;
import org.opendaylight.mdsal.binding.dom.codec.api.BindingCodecTreeNode;
import org.opendaylight.mdsal.binding.dom.codec.api.BindingNormalizedNodeSerializer;
import org.opendaylight.mdsal.binding.generator.api.ClassLoadingStrategy;
import org.opendaylight.mdsal.binding.generator.util.BindingRuntimeContext;
import org.opendaylight.yangtools.binding.data.codec.impl.BindingNormalizedNodeCodecRegistry;
import org.opendaylight.yangtools.binding.data.codec.impl.MissingSchemaException;
import org.opendaylight.yangtools.yang.binding.BindingMapping;
import org.opendaylight.yangtools.yang.binding.DataContainer;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;
import org.opendaylight.yangtools.yang.binding.Notification;
import org.opendaylight.yangtools.yang.binding.RpcService;
import org.opendaylight.yangtools.yang.binding.util.BindingReflections;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.QNameModule;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.ContainerNode;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.impl.codec.DeserializationException;
import org.opendaylight.yangtools.yang.model.api.ContainerSchemaNode;
import org.opendaylight.yangtools.yang.model.api.Module;
import org.opendaylight.yangtools.yang.model.api.NotificationDefinition;
import org.opendaylight.yangtools.yang.model.api.RpcDefinition;
import org.opendaylight.yangtools.yang.model.api.SchemaContext;
import org.opendaylight.yangtools.yang.model.api.SchemaContextListener;
import org.opendaylight.yangtools.yang.model.api.SchemaNode;
import org.opendaylight.yangtools.yang.model.api.SchemaPath;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.meta.StatementSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BindingToNormalizedNodeCodec
implements BindingCodecTreeFactory,
BindingNormalizedNodeSerializer,
SchemaContextListener,
AutoCloseable {
    private static final long WAIT_DURATION_SEC = 5L;
    private static final Logger LOG = LoggerFactory.getLogger(BindingToNormalizedNodeCodec.class);
    private final BindingNormalizedNodeCodecRegistry codecRegistry;
    private final ClassLoadingStrategy classLoadingStrategy;
    private final FutureSchema futureSchema;
    private final LoadingCache<InstanceIdentifier<?>, YangInstanceIdentifier> iiCache = CacheBuilder.newBuilder().softValues().build(new CacheLoader<InstanceIdentifier<?>, YangInstanceIdentifier>(){

        public YangInstanceIdentifier load(InstanceIdentifier<?> key) throws Exception {
            return BindingToNormalizedNodeCodec.this.toYangInstanceIdentifierBlocking(key);
        }
    });
    private DataNormalizer legacyToNormalized;

    public BindingToNormalizedNodeCodec(ClassLoadingStrategy classLoadingStrategy, BindingNormalizedNodeCodecRegistry codecRegistry) {
        this(classLoadingStrategy, codecRegistry, false);
    }

    public BindingToNormalizedNodeCodec(ClassLoadingStrategy classLoadingStrategy, BindingNormalizedNodeCodecRegistry codecRegistry, boolean waitForSchema) {
        this.classLoadingStrategy = (ClassLoadingStrategy)Preconditions.checkNotNull((Object)classLoadingStrategy, (Object)"classLoadingStrategy");
        this.codecRegistry = (BindingNormalizedNodeCodecRegistry)Preconditions.checkNotNull((Object)codecRegistry, (Object)"codecRegistry");
        this.futureSchema = new FutureSchema(5L, TimeUnit.SECONDS, waitForSchema);
    }

    YangInstanceIdentifier toYangInstanceIdentifierBlocking(InstanceIdentifier<? extends DataObject> binding) {
        try {
            return this.codecRegistry.toYangInstanceIdentifier(binding);
        }
        catch (MissingSchemaException e) {
            this.waitForSchema(BindingToNormalizedNodeCodec.decompose(binding), e);
            return this.codecRegistry.toYangInstanceIdentifier(binding);
        }
    }

    public YangInstanceIdentifier toNormalized(InstanceIdentifier<? extends DataObject> binding) {
        return this.codecRegistry.toYangInstanceIdentifier(binding);
    }

    public YangInstanceIdentifier toYangInstanceIdentifier(InstanceIdentifier<?> binding) {
        return this.codecRegistry.toYangInstanceIdentifier(binding);
    }

    YangInstanceIdentifier toYangInstanceIdentifierCached(InstanceIdentifier<?> binding) {
        return (YangInstanceIdentifier)this.iiCache.getUnchecked(binding);
    }

    public <T extends DataObject> Map.Entry<YangInstanceIdentifier, NormalizedNode<?, ?>> toNormalizedNode(InstanceIdentifier<T> path, T data) {
        return this.codecRegistry.toNormalizedNode(path, data);
    }

    public Map.Entry<YangInstanceIdentifier, NormalizedNode<?, ?>> toNormalizedNode(Map.Entry<InstanceIdentifier<? extends DataObject>, DataObject> binding) {
        return this.toNormalizedNode(binding.getKey(), binding.getValue());
    }

    public Map.Entry<InstanceIdentifier<?>, DataObject> fromNormalizedNode(YangInstanceIdentifier path, NormalizedNode<?, ?> data) {
        return this.codecRegistry.fromNormalizedNode(path, data);
    }

    public Notification fromNormalizedNodeNotification(SchemaPath path, ContainerNode data) {
        return this.codecRegistry.fromNormalizedNodeNotification(path, data);
    }

    public DataObject fromNormalizedNodeRpcData(SchemaPath path, ContainerNode data) {
        return this.codecRegistry.fromNormalizedNodeRpcData(path, data);
    }

    public InstanceIdentifier<?> fromYangInstanceIdentifier(YangInstanceIdentifier dom) {
        return this.codecRegistry.fromYangInstanceIdentifier(dom);
    }

    public ContainerNode toNormalizedNodeNotification(Notification data) {
        return this.codecRegistry.toNormalizedNodeNotification(data);
    }

    public ContainerNode toNormalizedNodeRpcData(DataContainer data) {
        return this.codecRegistry.toNormalizedNodeRpcData(data);
    }

    public Optional<InstanceIdentifier<? extends DataObject>> toBinding(YangInstanceIdentifier normalized) throws DeserializationException {
        try {
            return Optional.fromNullable((Object)this.codecRegistry.fromYangInstanceIdentifier(normalized));
        }
        catch (IllegalArgumentException e) {
            return Optional.absent();
        }
    }

    public DataNormalizer getDataNormalizer() {
        return this.legacyToNormalized;
    }

    public Optional<Map.Entry<InstanceIdentifier<? extends DataObject>, DataObject>> toBinding(@Nonnull Map.Entry<YangInstanceIdentifier, ? extends NormalizedNode<?, ?>> normalized) throws DeserializationException {
        try {
            Map.Entry binding = (Map.Entry)Map.Entry.class.cast(this.codecRegistry.fromNormalizedNode(normalized.getKey(), normalized.getValue()));
            return Optional.fromNullable((Object)binding);
        }
        catch (IllegalArgumentException e) {
            return Optional.absent();
        }
    }

    public void onGlobalContextUpdated(SchemaContext schemaContext) {
        this.legacyToNormalized = new DataNormalizer(schemaContext);
        BindingRuntimeContext runtimeContext = BindingRuntimeContext.create((ClassLoadingStrategy)this.classLoadingStrategy, (SchemaContext)schemaContext);
        this.codecRegistry.onBindingRuntimeContextUpdated(runtimeContext);
        this.futureSchema.onRuntimeContextUpdated(runtimeContext);
    }

    public <T extends DataObject> Function<Optional<NormalizedNode<?, ?>>, Optional<T>> deserializeFunction(InstanceIdentifier<T> path) {
        return this.codecRegistry.deserializeFunction(path);
    }

    public NormalizedNode<?, ?> getDefaultNodeFor(YangInstanceIdentifier path) {
        Iterator iterator = path.getPathArguments().iterator();
        DataNormalizationOperation currentOp = this.legacyToNormalized.getRootOperation();
        while (iterator.hasNext()) {
            YangInstanceIdentifier.PathArgument currentArg = (YangInstanceIdentifier.PathArgument)iterator.next();
            try {
                currentOp = currentOp.getChild(currentArg);
            }
            catch (DataNormalizationException e) {
                throw new IllegalArgumentException(String.format("Invalid child encountered in path %s", path), e);
            }
        }
        return currentOp.createDefault(path.getLastPathArgument());
    }

    public BindingNormalizedNodeCodecRegistry getCodecRegistry() {
        return this.codecRegistry;
    }

    @Override
    public void close() {
    }

    public BindingNormalizedNodeCodecRegistry getCodecFactory() {
        return this.codecRegistry;
    }

    public ImmutableBiMap<Method, SchemaPath> getRpcMethodToSchemaPath(Class<? extends RpcService> key) {
        Module module = this.getModuleBlocking(key);
        ImmutableBiMap.Builder ret = ImmutableBiMap.builder();
        try {
            for (RpcDefinition rpcDef : module.getRpcs()) {
                Method method = this.findRpcMethod(key, rpcDef);
                ret.put((Object)method, (Object)rpcDef.getPath());
            }
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException("Rpc defined in model does not have representation in generated class.", e);
        }
        return ret.build();
    }

    protected ImmutableBiMap<Method, RpcDefinition> getRpcMethodToSchema(Class<? extends RpcService> key) {
        Module module = this.getModuleBlocking(key);
        ImmutableBiMap.Builder ret = ImmutableBiMap.builder();
        try {
            for (RpcDefinition rpcDef : module.getRpcs()) {
                Method method = this.findRpcMethod(key, rpcDef);
                ret.put((Object)method, (Object)rpcDef);
            }
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException("Rpc defined in model does not have representation in generated class.", e);
        }
        return ret.build();
    }

    private Module getModuleBlocking(Class<?> modeledClass) {
        QNameModule moduleName = BindingReflections.getQNameModule(modeledClass);
        URI namespace = moduleName.getNamespace();
        Date revision = moduleName.getRevision();
        Module module = this.runtimeContext().getSchemaContext().findModuleByNamespaceAndRevision(namespace, revision);
        if (module == null && this.futureSchema.waitForSchema(namespace, revision)) {
            module = this.runtimeContext().getSchemaContext().findModuleByNamespaceAndRevision(namespace, revision);
        }
        Preconditions.checkState((module != null ? 1 : 0) != 0, (String)"Schema for %s is not available.", modeledClass);
        return module;
    }

    private void waitForSchema(Collection<Class<?>> binding, MissingSchemaException e) {
        LOG.warn("Blocking thread to wait for schema convergence updates for {} {}", (Object)this.futureSchema.getDuration(), (Object)this.futureSchema.getUnit());
        if (this.futureSchema.waitForSchema(binding)) {
            return;
        }
        throw e;
    }

    private Method findRpcMethod(Class<? extends RpcService> key, RpcDefinition rpcDef) throws NoSuchMethodException {
        String methodName = BindingMapping.getMethodName((QName)rpcDef.getQName());
        if (rpcDef.getInput() != null && BindingToNormalizedNodeCodec.isExplicitStatement(rpcDef.getInput())) {
            Class inputClz = this.runtimeContext().getClassForSchema((SchemaNode)rpcDef.getInput());
            return key.getMethod(methodName, inputClz);
        }
        return key.getMethod(methodName, new Class[0]);
    }

    private static boolean isExplicitStatement(ContainerSchemaNode node) {
        return node instanceof EffectiveStatement && ((EffectiveStatement)node).getDeclared().getStatementSource() == StatementSource.DECLARATION;
    }

    private BindingRuntimeContext runtimeContext() {
        return this.futureSchema.runtimeContext();
    }

    public BindingCodecTree create(BindingRuntimeContext context) {
        return this.codecRegistry.create(context);
    }

    public BindingCodecTree create(SchemaContext context, Class<?> ... bindingClasses) {
        return this.codecRegistry.create(context, (Class[])bindingClasses);
    }

    @Nonnull
    protected Map.Entry<InstanceIdentifier<?>, BindingCodecTreeNode<?>> getSubtreeCodec(YangInstanceIdentifier domIdentifier) {
        BindingCodecTree currentCodecTree = this.codecRegistry.getCodecContext();
        InstanceIdentifier bindingPath = this.codecRegistry.fromYangInstanceIdentifier(domIdentifier);
        Preconditions.checkArgument((bindingPath != null ? 1 : 0) != 0);
        BindingCodecTreeNode codecContext = currentCodecTree.getSubtreeCodec(bindingPath);
        return new AbstractMap.SimpleEntry(bindingPath, codecContext);
    }

    public Set<Class<? extends Notification>> getNotificationClasses(Set<SchemaPath> interested) {
        HashSet<Class<? extends Notification>> result = new HashSet<Class<? extends Notification>>();
        Set knownNotifications = this.runtimeContext().getSchemaContext().getNotifications();
        for (NotificationDefinition notification : knownNotifications) {
            if (!interested.contains(notification.getPath())) continue;
            try {
                result.add(this.runtimeContext().getClassForSchema((SchemaNode)notification));
            }
            catch (IllegalStateException e) {
                LOG.warn("Class for {} is currently not known.", (Object)notification.getPath(), (Object)e);
            }
        }
        return result;
    }

    private static Collection<Class<?>> decompose(InstanceIdentifier<?> path) {
        HashSet clazzes = new HashSet();
        for (InstanceIdentifier.PathArgument arg : path.getPathArguments()) {
            clazzes.add(arg.getType());
        }
        return clazzes;
    }
}

