/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.md.sal.binding.impl;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.util.concurrent.CheckedFuture;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Map;
import org.opendaylight.controller.md.sal.binding.impl.BindingToNormalizedNodeCodec;
import org.opendaylight.controller.md.sal.binding.impl.ContextReferenceExtractor;
import org.opendaylight.controller.md.sal.binding.impl.LazyDOMRpcResultFuture;
import org.opendaylight.controller.md.sal.binding.impl.LazySerializedContainerNode;
import org.opendaylight.controller.md.sal.dom.api.DOMRpcResult;
import org.opendaylight.controller.md.sal.dom.api.DOMRpcService;
import org.opendaylight.controller.md.sal.dom.broker.spi.rpc.RpcRoutingStrategy;
import org.opendaylight.mdsal.binding.dom.codec.api.BindingNormalizedNodeSerializer;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;
import org.opendaylight.yangtools.yang.binding.RpcService;
import org.opendaylight.yangtools.yang.binding.util.BindingReflections;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.RpcResult;
import org.opendaylight.yangtools.yang.common.RpcResultBuilder;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.ContainerNode;
import org.opendaylight.yangtools.yang.data.api.schema.LeafNode;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.impl.schema.ImmutableNodes;
import org.opendaylight.yangtools.yang.model.api.RpcDefinition;
import org.opendaylight.yangtools.yang.model.api.SchemaPath;

class RpcServiceAdapter
implements InvocationHandler {
    private final ImmutableMap<Method, RpcInvocationStrategy> rpcNames;
    private final Class<? extends RpcService> type;
    private final BindingToNormalizedNodeCodec codec;
    private final DOMRpcService delegate;
    private final RpcService proxy;

    RpcServiceAdapter(Class<? extends RpcService> type, BindingToNormalizedNodeCodec codec, DOMRpcService domService) {
        this.type = (Class)Preconditions.checkNotNull(type);
        this.codec = (BindingToNormalizedNodeCodec)Preconditions.checkNotNull((Object)codec);
        this.delegate = (DOMRpcService)Preconditions.checkNotNull((Object)domService);
        ImmutableMap.Builder rpcBuilder = ImmutableMap.builder();
        for (Map.Entry rpc : codec.getRpcMethodToSchema(type).entrySet()) {
            rpcBuilder.put(rpc.getKey(), (Object)this.createStrategy((Method)rpc.getKey(), (RpcDefinition)rpc.getValue()));
        }
        this.rpcNames = rpcBuilder.build();
        this.proxy = (RpcService)Proxy.newProxyInstance(type.getClassLoader(), new Class[]{type}, (InvocationHandler)this);
    }

    private ListenableFuture<RpcResult<?>> invoke0(SchemaPath schemaPath, NormalizedNode<?, ?> input) {
        CheckedFuture result = this.delegate.invokeRpc(schemaPath, input);
        if (result instanceof LazyDOMRpcResultFuture) {
            return ((LazyDOMRpcResultFuture)result).getBindingFuture();
        }
        return RpcServiceAdapter.transformFuture(schemaPath, (ListenableFuture<DOMRpcResult>)result, (BindingNormalizedNodeSerializer)this.codec.getCodecFactory());
    }

    private RpcInvocationStrategy createStrategy(Method method, RpcDefinition schema) {
        RpcRoutingStrategy strategy = RpcRoutingStrategy.from((RpcDefinition)schema);
        if (strategy.isContextBasedRouted()) {
            return new RoutedStrategy(schema.getPath(), method, strategy.getLeaf());
        }
        return new NonRoutedStrategy(schema.getPath());
    }

    RpcService getProxy() {
        return this.proxy;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        RpcInvocationStrategy rpc = (RpcInvocationStrategy)this.rpcNames.get((Object)method);
        if (rpc != null) {
            if (method.getParameterTypes().length == 0) {
                return rpc.invokeEmpty();
            }
            if (args.length != 1) {
                throw new IllegalArgumentException("Input must be provided.");
            }
            return rpc.invoke((DataObject)args[0]);
        }
        if (RpcServiceAdapter.isObjectMethod(method)) {
            return this.callObjectMethod(proxy, method, args);
        }
        throw new UnsupportedOperationException("Method " + method.toString() + "is unsupported.");
    }

    private static boolean isObjectMethod(Method m) {
        switch (m.getName()) {
            case "toString": {
                return m.getReturnType().equals(String.class) && m.getParameterTypes().length == 0;
            }
            case "hashCode": {
                return m.getReturnType().equals(Integer.TYPE) && m.getParameterTypes().length == 0;
            }
            case "equals": {
                return m.getReturnType().equals(Boolean.TYPE) && m.getParameterTypes().length == 1 && m.getParameterTypes()[0] == Object.class;
            }
        }
        return false;
    }

    private Object callObjectMethod(Object self, Method m, Object[] args) {
        switch (m.getName()) {
            case "toString": {
                return this.type.getName() + "$Adapter{delegate=" + this.delegate.toString() + "}";
            }
            case "hashCode": {
                return System.identityHashCode(self);
            }
            case "equals": {
                return self == args[0];
            }
        }
        return null;
    }

    private static ListenableFuture<RpcResult<?>> transformFuture(SchemaPath rpc, ListenableFuture<DOMRpcResult> domFuture, BindingNormalizedNodeSerializer codec) {
        return Futures.transform(domFuture, input -> {
            DataObject bindingResult;
            NormalizedNode domData = input.getResult();
            if (domData != null) {
                SchemaPath rpcOutput = rpc.createChild(new QName[]{QName.create((QName)rpc.getLastComponent(), (String)"output")});
                bindingResult = codec.fromNormalizedNodeRpcData(rpcOutput, (ContainerNode)domData);
            } else {
                bindingResult = null;
            }
            return (RpcResult)RpcResult.class.cast(RpcResultBuilder.success(bindingResult).build());
        });
    }

    private final class RoutedStrategy
    extends RpcInvocationStrategy {
        private final ContextReferenceExtractor refExtractor;
        private final YangInstanceIdentifier.NodeIdentifier contextName;

        protected RoutedStrategy(SchemaPath path, Method rpcMethod, QName leafName) {
            super(path);
            Class inputType = (Class)BindingReflections.resolveRpcInputClass((Method)rpcMethod).get();
            this.refExtractor = ContextReferenceExtractor.from(inputType);
            this.contextName = new YangInstanceIdentifier.NodeIdentifier(leafName);
        }

        @Override
        NormalizedNode<?, ?> serialize(DataObject input) {
            InstanceIdentifier<?> bindingII = this.refExtractor.extract(input);
            if (bindingII != null) {
                YangInstanceIdentifier yangII = RpcServiceAdapter.this.codec.toYangInstanceIdentifierCached(bindingII);
                LeafNode contextRef = ImmutableNodes.leafNode((YangInstanceIdentifier.NodeIdentifier)this.contextName, (Object)yangII);
                return LazySerializedContainerNode.withContextRef(this.getRpcName(), input, contextRef, (BindingNormalizedNodeSerializer)RpcServiceAdapter.this.codec.getCodecRegistry());
            }
            return LazySerializedContainerNode.create(this.getRpcName(), input, (BindingNormalizedNodeSerializer)RpcServiceAdapter.this.codec.getCodecRegistry());
        }
    }

    private final class NonRoutedStrategy
    extends RpcInvocationStrategy {
        protected NonRoutedStrategy(SchemaPath path) {
            super(path);
        }

        @Override
        NormalizedNode<?, ?> serialize(DataObject input) {
            return LazySerializedContainerNode.create(this.getRpcName(), input, (BindingNormalizedNodeSerializer)RpcServiceAdapter.this.codec.getCodecRegistry());
        }
    }

    private abstract class RpcInvocationStrategy {
        private final SchemaPath rpcName;

        protected RpcInvocationStrategy(SchemaPath path) {
            this.rpcName = path;
        }

        final ListenableFuture<RpcResult<?>> invoke(DataObject input) {
            return RpcServiceAdapter.this.invoke0(this.rpcName, this.serialize(input));
        }

        abstract NormalizedNode<?, ?> serialize(DataObject var1);

        final ListenableFuture<RpcResult<?>> invokeEmpty() {
            return RpcServiceAdapter.this.invoke0(this.rpcName, null);
        }

        final SchemaPath getRpcName() {
            return this.rpcName;
        }
    }
}

