/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.md.sal.binding.spi;

import com.google.common.base.Optional;
import com.google.common.cache.CacheLoader;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opendaylight.controller.md.sal.binding.spi.AdapterBuilder;

public abstract class AdapterLoader<T, D>
extends CacheLoader<Class<? extends T>, Optional<T>> {
    public Optional<T> load(Class<? extends T> key) {
        AdapterBuilder<T, D> builder = this.createBuilder(key);
        for (Class<D> reqDeleg : builder.getRequiredDelegates()) {
            D deleg = this.getDelegate(reqDeleg);
            if (deleg != null) {
                builder.addDelegate(reqDeleg, deleg);
                continue;
            }
            return Optional.absent();
        }
        return Optional.of(builder.build());
    }

    @Nullable
    protected abstract D getDelegate(Class<? extends D> var1);

    @Nonnull
    protected abstract AdapterBuilder<? extends T, D> createBuilder(Class<? extends T> var1);
}

