/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.sal.binding.codegen.impl;

import com.google.common.util.concurrent.ForwardingBlockingQueue;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javassist.ClassPool;
import org.apache.commons.lang3.StringUtils;
import org.opendaylight.mdsal.binding.generator.util.JavassistUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SingletonHolder {
    private static final Logger LOG = LoggerFactory.getLogger(SingletonHolder.class);
    public static final ClassPool CLASS_POOL = ClassPool.getDefault();
    public static final JavassistUtils JAVASSIST = JavassistUtils.forClassPool((ClassPool)CLASS_POOL);
    public static final int CORE_NOTIFICATION_THREADS = 4;
    public static final int MAX_NOTIFICATION_THREADS = 32;
    public static final int MAX_NOTIFICATION_QUEUE_SIZE = 1000;
    public static final int NOTIFICATION_THREAD_LIFE = 15;
    private static final String NOTIFICATION_QUEUE_SIZE_PROPERTY = "mdsal.notificationqueue.size";
    private static ListeningExecutorService NOTIFICATION_EXECUTOR = null;
    private static ListeningExecutorService COMMIT_EXECUTOR = null;
    private static ListeningExecutorService CHANGE_EVENT_EXECUTOR = null;

    @Deprecated
    public static synchronized ListeningExecutorService getDefaultNotificationExecutor() {
        if (NOTIFICATION_EXECUTOR == null) {
            int queueSize = 1000;
            String queueValue = System.getProperty(NOTIFICATION_QUEUE_SIZE_PROPERTY);
            if (StringUtils.isNotBlank((CharSequence)queueValue)) {
                try {
                    queueSize = Integer.parseInt(queueValue);
                    LOG.trace("Queue size was set to {}", (Object)queueSize);
                }
                catch (NumberFormatException e) {
                    LOG.warn("Cannot parse {} as set by {}, using default {}", new Object[]{queueValue, NOTIFICATION_QUEUE_SIZE_PROPERTY, queueSize});
                }
            }
            final LinkedBlockingQueue delegate = new LinkedBlockingQueue(queueSize);
            ForwardingBlockingQueue<Runnable> queue = new ForwardingBlockingQueue<Runnable>(){

                protected BlockingQueue<Runnable> delegate() {
                    return delegate;
                }

                public boolean offer(Runnable r) {
                    return false;
                }
            };
            ThreadFactory factory = new ThreadFactoryBuilder().setDaemon(true).setNameFormat("md-sal-binding-notification-%d").build();
            ThreadPoolExecutor executor = new ThreadPoolExecutor(4, 32, 15L, TimeUnit.SECONDS, (BlockingQueue<Runnable>)queue, factory, (r, executor1) -> {
                try {
                    executor1.getQueue().put(r);
                }
                catch (InterruptedException e) {
                    throw new RejectedExecutionException("Interrupted while waiting on the queue", e);
                }
            });
            NOTIFICATION_EXECUTOR = MoreExecutors.listeningDecorator((ExecutorService)executor);
        }
        return NOTIFICATION_EXECUTOR;
    }

    @Deprecated
    public static synchronized ListeningExecutorService getDefaultCommitExecutor() {
        if (COMMIT_EXECUTOR == null) {
            ThreadFactory factory = new ThreadFactoryBuilder().setDaemon(true).setNameFormat("md-sal-binding-commit-%d").build();
            ExecutorService executor = Executors.newSingleThreadExecutor(factory);
            COMMIT_EXECUTOR = MoreExecutors.listeningDecorator((ExecutorService)executor);
        }
        return COMMIT_EXECUTOR;
    }

    public static ExecutorService getDefaultChangeEventExecutor() {
        if (CHANGE_EVENT_EXECUTOR == null) {
            ThreadFactory factory = new ThreadFactoryBuilder().setDaemon(true).setNameFormat("md-sal-binding-change-%d").build();
            ExecutorService executor = Executors.newSingleThreadExecutor(factory);
            CHANGE_EVENT_EXECUTOR = MoreExecutors.listeningDecorator((ExecutorService)executor);
        }
        return CHANGE_EVENT_EXECUTOR;
    }
}

