/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.md.sal.binding.impl;

import java.util.Collection;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.junit.Before;
import org.junit.Test;
import org.mockito.AdditionalMatchers;
import org.mockito.ArgumentMatcher;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.opendaylight.controller.md.sal.binding.api.ClusteredDataTreeChangeListener;
import org.opendaylight.controller.md.sal.binding.api.DataTreeChangeListener;
import org.opendaylight.controller.md.sal.binding.api.DataTreeChangeService;
import org.opendaylight.controller.md.sal.binding.api.DataTreeIdentifier;
import org.opendaylight.controller.md.sal.binding.api.DataTreeModification;
import org.opendaylight.controller.md.sal.binding.impl.BindingDOMDataTreeChangeServiceAdapter;
import org.opendaylight.controller.md.sal.binding.impl.BindingToNormalizedNodeCodec;
import org.opendaylight.controller.md.sal.common.api.data.LogicalDatastoreType;
import org.opendaylight.controller.md.sal.dom.api.ClusteredDOMDataTreeChangeListener;
import org.opendaylight.controller.md.sal.dom.api.DOMDataTreeChangeListener;
import org.opendaylight.controller.md.sal.dom.api.DOMDataTreeChangeService;
import org.opendaylight.controller.md.sal.dom.api.DOMDataTreeIdentifier;
import org.opendaylight.mdsal.binding.dom.codec.impl.BindingNormalizedNodeCodecRegistry;
import org.opendaylight.mdsal.binding.generator.api.ClassLoadingStrategy;
import org.opendaylight.mdsal.binding.generator.impl.GeneratedClassLoadingStrategy;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.test.list.rev140701.Top;
import org.opendaylight.yangtools.concepts.ListenerRegistration;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;

public class BindingDOMDataTreeChangeServiceAdapterTest {
    private static final InstanceIdentifier<Top> TOP_PATH = InstanceIdentifier.create(Top.class);
    @Mock
    private DOMDataTreeChangeService mockDOMService;
    @Mock
    private GeneratedClassLoadingStrategy classLoadingStrategy;
    @Mock
    private BindingNormalizedNodeCodecRegistry codecRegistry;
    @Mock
    private YangInstanceIdentifier mockYangID;
    @Mock
    private ListenerRegistration mockDOMReg;

    @Before
    public void setUp() {
        MockitoAnnotations.initMocks((Object)this);
        ((BindingNormalizedNodeCodecRegistry)Mockito.doReturn((Object)this.mockYangID).when((Object)this.codecRegistry)).toYangInstanceIdentifier(TOP_PATH);
    }

    @Test
    public void testRegisterDataTreeChangeListener() {
        BindingToNormalizedNodeCodec codec = new BindingToNormalizedNodeCodec((ClassLoadingStrategy)this.classLoadingStrategy, this.codecRegistry);
        DataTreeChangeService service = BindingDOMDataTreeChangeServiceAdapter.create((BindingToNormalizedNodeCodec)codec, (DOMDataTreeChangeService)this.mockDOMService);
        ((DOMDataTreeChangeService)Mockito.doReturn((Object)this.mockDOMReg).when((Object)this.mockDOMService)).registerDataTreeChangeListener(BindingDOMDataTreeChangeServiceAdapterTest.domDataTreeIdentifier(this.mockYangID), (DOMDataTreeChangeListener)Matchers.any(DOMDataTreeChangeListener.class));
        DataTreeIdentifier treeId = new DataTreeIdentifier(LogicalDatastoreType.CONFIGURATION, TOP_PATH);
        TestClusteredDataTreeChangeListener mockClusteredListener = new TestClusteredDataTreeChangeListener();
        service.registerDataTreeChangeListener(treeId, (DataTreeChangeListener)mockClusteredListener);
        ((DOMDataTreeChangeService)Mockito.verify((Object)this.mockDOMService)).registerDataTreeChangeListener(BindingDOMDataTreeChangeServiceAdapterTest.domDataTreeIdentifier(this.mockYangID), (DOMDataTreeChangeListener)Matchers.isA(ClusteredDOMDataTreeChangeListener.class));
        Mockito.reset((Object[])new DOMDataTreeChangeService[]{this.mockDOMService});
        ((DOMDataTreeChangeService)Mockito.doReturn((Object)this.mockDOMReg).when((Object)this.mockDOMService)).registerDataTreeChangeListener(BindingDOMDataTreeChangeServiceAdapterTest.domDataTreeIdentifier(this.mockYangID), (DOMDataTreeChangeListener)Matchers.any(DOMDataTreeChangeListener.class));
        TestDataTreeChangeListener mockNonClusteredListener = new TestDataTreeChangeListener();
        service.registerDataTreeChangeListener(treeId, (DataTreeChangeListener)mockNonClusteredListener);
        ((DOMDataTreeChangeService)Mockito.verify((Object)this.mockDOMService)).registerDataTreeChangeListener(BindingDOMDataTreeChangeServiceAdapterTest.domDataTreeIdentifier(this.mockYangID), (DOMDataTreeChangeListener)AdditionalMatchers.not((Object)Matchers.isA(ClusteredDOMDataTreeChangeListener.class)));
    }

    static DOMDataTreeIdentifier domDataTreeIdentifier(final YangInstanceIdentifier yangID) {
        return (DOMDataTreeIdentifier)Matchers.argThat((Matcher)new ArgumentMatcher<DOMDataTreeIdentifier>(){

            public boolean matches(Object argument) {
                DOMDataTreeIdentifier treeId = (DOMDataTreeIdentifier)argument;
                return treeId.getDatastoreType() == LogicalDatastoreType.CONFIGURATION && yangID.equals((Object)treeId.getRootIdentifier());
            }

            public void describeTo(Description description) {
                description.appendValue((Object)new DOMDataTreeIdentifier(LogicalDatastoreType.CONFIGURATION, yangID));
            }
        });
    }

    private static class TestDataTreeChangeListener
    implements DataTreeChangeListener<Top> {
        private TestDataTreeChangeListener() {
        }

        public void onDataTreeChanged(Collection<DataTreeModification<Top>> changes) {
        }
    }

    private static class TestClusteredDataTreeChangeListener
    implements ClusteredDataTreeChangeListener<Top> {
        private TestClusteredDataTreeChangeListener() {
        }

        public void onDataTreeChanged(Collection<DataTreeModification<Top>> changes) {
        }
    }
}

