/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.md.sal.binding.impl;

import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.SetMultimap;
import com.google.common.util.concurrent.Uninterruptibles;
import java.lang.reflect.Method;
import java.net.URI;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import javassist.ClassPool;
import org.junit.Assert;
import org.junit.Test;
import org.opendaylight.controller.md.sal.binding.impl.BindingToNormalizedNodeCodec;
import org.opendaylight.controller.md.sal.binding.test.AbstractSchemaAwareTest;
import org.opendaylight.mdsal.binding.dom.codec.gen.impl.DataObjectSerializerGenerator;
import org.opendaylight.mdsal.binding.dom.codec.gen.impl.StreamWriterGenerator;
import org.opendaylight.mdsal.binding.dom.codec.impl.BindingNormalizedNodeCodecRegistry;
import org.opendaylight.mdsal.binding.generator.api.ClassLoadingStrategy;
import org.opendaylight.mdsal.binding.generator.impl.GeneratedClassLoadingStrategy;
import org.opendaylight.mdsal.binding.generator.util.JavassistUtils;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.test.augment.rev140709.TreeComplexUsesAugment;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.test.augment.rev140709.TreeLeafOnlyAugment;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.test.bi.ba.rpcservice.rev140701.OpendaylightTestRpcServiceService;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.test.list.rev140701.Top;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.test.list.rev140701.two.level.list.TopLevelList;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.test.list.rev140701.two.level.list.TopLevelListKey;
import org.opendaylight.yangtools.yang.binding.Identifier;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.QNameModule;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.model.api.Module;
import org.opendaylight.yangtools.yang.model.api.SchemaContext;
import org.opendaylight.yangtools.yang.model.util.AbstractSchemaContext;

public class BindingNormalizedCodecTest
extends AbstractSchemaAwareTest {
    private static final TopLevelListKey TOP_FOO_KEY = new TopLevelListKey("foo");
    private static final InstanceIdentifier<TopLevelList> BA_TOP_LEVEL_LIST = InstanceIdentifier.builder(Top.class).child(TopLevelList.class, (Identifier)TOP_FOO_KEY).build();
    private static final InstanceIdentifier<TreeLeafOnlyAugment> BA_TREE_LEAF_ONLY = BA_TOP_LEVEL_LIST.augmentation(TreeLeafOnlyAugment.class);
    private static final InstanceIdentifier<TreeComplexUsesAugment> BA_TREE_COMPLEX_USES = BA_TOP_LEVEL_LIST.augmentation(TreeComplexUsesAugment.class);
    private static final QName SIMPLE_VALUE_QNAME = QName.create((QName)TreeComplexUsesAugment.QNAME, (String)"simple-value");
    private static final QName NAME_QNAME = QName.create((QName)Top.QNAME, (String)"name");
    private static final YangInstanceIdentifier BI_TOP_LEVEL_LIST = YangInstanceIdentifier.builder().node(Top.QNAME).node(TopLevelList.QNAME).nodeWithKey(TopLevelList.QNAME, NAME_QNAME, (Object)TOP_FOO_KEY.getName()).build();
    private BindingToNormalizedNodeCodec codec;
    private SchemaContext context;

    @Override
    protected void setupWithSchema(SchemaContext schemaContext) {
        this.context = schemaContext;
        DataObjectSerializerGenerator streamWriter = StreamWriterGenerator.create((JavassistUtils)JavassistUtils.forClassPool((ClassPool)ClassPool.getDefault()));
        BindingNormalizedNodeCodecRegistry registry = new BindingNormalizedNodeCodecRegistry(streamWriter);
        this.codec = new BindingToNormalizedNodeCodec((ClassLoadingStrategy)GeneratedClassLoadingStrategy.getTCCLClassLoadingStrategy(), registry, true);
    }

    @Test
    public void testComplexAugmentationSerialization() {
        this.codec.onGlobalContextUpdated(this.context);
        YangInstanceIdentifier.PathArgument lastArg = this.codec.toYangInstanceIdentifier(BA_TREE_COMPLEX_USES).getLastPathArgument();
        Assert.assertTrue((boolean)(lastArg instanceof YangInstanceIdentifier.AugmentationIdentifier));
    }

    @Test
    public void testLeafOnlyAugmentationSerialization() {
        this.codec.onGlobalContextUpdated(this.context);
        YangInstanceIdentifier.PathArgument leafOnlyLastArg = this.codec.toYangInstanceIdentifier(BA_TREE_LEAF_ONLY).getLastPathArgument();
        Assert.assertTrue((boolean)(leafOnlyLastArg instanceof YangInstanceIdentifier.AugmentationIdentifier));
        Assert.assertTrue((boolean)((YangInstanceIdentifier.AugmentationIdentifier)leafOnlyLastArg).getPossibleChildNames().contains(SIMPLE_VALUE_QNAME));
    }

    @Test
    public void testToYangInstanceIdentifierBlocking() {
        this.codec.onGlobalContextUpdated((SchemaContext)new EmptySchemaContext());
        CountDownLatch done = new CountDownLatch(1);
        AtomicReference yangId = new AtomicReference();
        AtomicReference error = new AtomicReference();
        new Thread(() -> {
            try {
                yangId.set(this.codec.toYangInstanceIdentifierBlocking(BA_TOP_LEVEL_LIST));
            }
            catch (RuntimeException e) {
                error.set(e);
            }
            finally {
                done.countDown();
            }
        }).start();
        Uninterruptibles.sleepUninterruptibly((long)500L, (TimeUnit)TimeUnit.MILLISECONDS);
        this.codec.onGlobalContextUpdated(this.context);
        Assert.assertEquals((String)"toYangInstanceIdentifierBlocking completed", (Object)true, (Object)Uninterruptibles.awaitUninterruptibly((CountDownLatch)done, (long)3L, (TimeUnit)TimeUnit.SECONDS));
        if (error.get() != null) {
            throw (RuntimeException)error.get();
        }
        Assert.assertEquals((String)"toYangInstanceIdentifierBlocking", (Object)BI_TOP_LEVEL_LIST, yangId.get());
    }

    @Test
    public void testGetRpcMethodToSchemaPathWithNoInitialSchemaContext() {
        this.testGetRpcMethodToSchemaPath();
    }

    @Test
    public void testGetRpcMethodToSchemaPathBlocking() {
        this.codec.onGlobalContextUpdated((SchemaContext)new EmptySchemaContext());
        this.testGetRpcMethodToSchemaPath();
    }

    private void testGetRpcMethodToSchemaPath() {
        CountDownLatch done = new CountDownLatch(1);
        AtomicReference retMap = new AtomicReference();
        AtomicReference error = new AtomicReference();
        new Thread(() -> {
            try {
                retMap.set(this.codec.getRpcMethodToSchemaPath(OpendaylightTestRpcServiceService.class));
            }
            catch (RuntimeException e) {
                error.set(e);
            }
            finally {
                done.countDown();
            }
        }).start();
        Uninterruptibles.sleepUninterruptibly((long)500L, (TimeUnit)TimeUnit.MILLISECONDS);
        this.codec.onGlobalContextUpdated(this.context);
        Assert.assertEquals((String)"getRpcMethodToSchemaPath completed", (Object)true, (Object)Uninterruptibles.awaitUninterruptibly((CountDownLatch)done, (long)3L, (TimeUnit)TimeUnit.SECONDS));
        if (error.get() != null) {
            throw (RuntimeException)error.get();
        }
        for (Method method : ((ImmutableBiMap)retMap.get()).keySet()) {
            if (!method.getName().equals("rockTheHouse")) continue;
            return;
        }
        Assert.fail((String)"rockTheHouse RPC method not found");
    }

    static class EmptySchemaContext
    extends AbstractSchemaContext {
        EmptySchemaContext() {
        }

        public Set<Module> getModules() {
            return ImmutableSet.of();
        }

        protected Map<QNameModule, Module> getModuleMap() {
            return ImmutableMap.of();
        }

        protected SetMultimap<URI, Module> getNamespaceToModules() {
            return ImmutableSetMultimap.of();
        }

        protected SetMultimap<String, Module> getNameToModules() {
            return ImmutableSetMultimap.of();
        }
    }
}

