/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.md.sal.binding.impl;

import org.junit.Assert;
import org.junit.Test;
import org.opendaylight.controller.md.sal.binding.impl.ContextReferenceExtractor;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.test.bi.ba.rpcservice.rev140701.RockTheHouseInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.test.bi.ba.rpcservice.rev140701.RockTheHouseInputBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.test.list.rev140701.Top;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.test.rpc.routing.rev140701.EncapsulatedRoute;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.test.rpc.routing.rev140701.EncapsulatedRouteInGrouping;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.test.rpc.routing.rev140701.RoutedSimpleRouteInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.test.rpc.routing.rev140701.RoutedSimpleRouteInputBuilder;
import org.opendaylight.yangtools.yang.binding.DataContainer;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;

public final class ContextExtractorTest {
    private static final InstanceIdentifier<?> TEST_ROUTE = InstanceIdentifier.create(Top.class);
    private static final Transitive TEST_GROUPING = new Transitive(){

        public Class<? extends DataContainer> getImplementedInterface() {
            return Transitive.class;
        }

        public EncapsulatedRoute getRoute() {
            return new EncapsulatedRoute(TEST_ROUTE);
        }
    };

    @Test
    public void testNonRoutedExtraction() {
        ContextReferenceExtractor extractor = ContextReferenceExtractor.from(RockTheHouseInput.class);
        RockTheHouseInput input = new RockTheHouseInputBuilder().build();
        InstanceIdentifier extractedValue = extractor.extract((DataObject)input);
        Assert.assertNull((Object)extractedValue);
    }

    @Test
    public void testRoutedSimpleExtraction() {
        ContextReferenceExtractor extractor = ContextReferenceExtractor.from(RoutedSimpleRouteInput.class);
        RoutedSimpleRouteInput input = new RoutedSimpleRouteInputBuilder().setRoute(TEST_ROUTE).build();
        InstanceIdentifier extractedValue = extractor.extract((DataObject)input);
        Assert.assertSame(TEST_ROUTE, (Object)extractedValue);
    }

    @Test
    public void testRoutedEncapsulatedExtraction() {
        ContextReferenceExtractor extractor = ContextReferenceExtractor.from(EncapsulatedRouteInGrouping.class);
        InstanceIdentifier extractedValue = extractor.extract((DataObject)TEST_GROUPING);
        Assert.assertSame(TEST_ROUTE, (Object)extractedValue);
    }

    @Test
    public void testRoutedEncapsulatedTransitiveExtraction() {
        ContextReferenceExtractor extractor = ContextReferenceExtractor.from(Transitive.class);
        InstanceIdentifier extractedValue = extractor.extract((DataObject)TEST_GROUPING);
        Assert.assertSame(TEST_ROUTE, (Object)extractedValue);
    }

    public static interface Transitive
    extends EncapsulatedRouteInGrouping {
    }
}

