/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.md.sal.binding.impl.test;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.opendaylight.controller.md.sal.binding.api.NotificationPublishService;
import org.opendaylight.controller.md.sal.binding.api.NotificationService;
import org.opendaylight.controller.md.sal.binding.compat.HeliumNotificationProviderServiceAdapter;
import org.opendaylight.controller.md.sal.binding.test.AbstractNotificationBrokerTest;
import org.opendaylight.controller.sal.binding.api.NotificationProviderService;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.test.list.rev140701.OpendaylightMdsalListTestListener;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.test.list.rev140701.TwoLevelListChanged;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.test.list.rev140701.TwoLevelListChangedBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.test.list.rev140701.two.level.list.TopLevelListBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.test.list.rev140701.two.level.list.TopLevelListKey;
import org.opendaylight.yangtools.concepts.ListenerRegistration;
import org.opendaylight.yangtools.yang.binding.Notification;
import org.opendaylight.yangtools.yang.binding.NotificationListener;

public class BackwardsCompatibleNotificationBrokerTest
extends AbstractNotificationBrokerTest {
    private NotificationProviderService notificationProviderService;

    @Before
    public void initTest() {
        NotificationService notificationService = this.getNotificationService();
        NotificationPublishService notificationPublishService = this.getNotificationPublishService();
        this.notificationProviderService = new HeliumNotificationProviderServiceAdapter(notificationPublishService, notificationService);
    }

    private TwoLevelListChanged createTestData() {
        TwoLevelListChangedBuilder tb = new TwoLevelListChangedBuilder();
        tb.setTopLevelList((List)ImmutableList.of((Object)new TopLevelListBuilder().withKey(new TopLevelListKey("test")).build()));
        return tb.build();
    }

    @Test
    public void testNotifSubscriptionForwarded() throws InterruptedException {
        CountDownLatch latch = new CountDownLatch(1);
        TwoLevelListChanged testData = this.createTestData();
        NotifTestListenerChild testNotifListener = new NotifTestListenerChild(latch);
        ListenerRegistration listenerRegistration = this.notificationProviderService.registerNotificationListener((NotificationListener)testNotifListener);
        this.notificationProviderService.publish((Notification)testData);
        latch.await(500L, TimeUnit.MILLISECONDS);
        Assert.assertTrue((testNotifListener.getReceivedNotifications().size() == 1 ? 1 : 0) != 0);
        Assert.assertEquals((Object)testData, (Object)testNotifListener.getReceivedNotifications().get(0));
        listenerRegistration.close();
    }

    private static class NotifTestListener
    implements OpendaylightMdsalListTestListener {
        private final List<TwoLevelListChanged> receivedNotifications = new ArrayList<TwoLevelListChanged>();
        private final CountDownLatch latch;

        NotifTestListener(CountDownLatch latch) {
            this.latch = latch;
        }

        public void onTwoLevelListChanged(TwoLevelListChanged notification) {
            this.receivedNotifications.add(notification);
            this.latch.countDown();
        }

        public List<TwoLevelListChanged> getReceivedNotifications() {
            return this.receivedNotifications;
        }
    }

    private static class NotifTestListenerChild
    extends NotifTestListener {
        NotifTestListenerChild(CountDownLatch latch) {
            super(latch);
        }
    }
}

