/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.md.sal.binding.impl.test;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.opendaylight.controller.md.sal.binding.api.DataBroker;
import org.opendaylight.controller.md.sal.binding.api.DataObjectModification;
import org.opendaylight.controller.md.sal.binding.api.DataTreeChangeListener;
import org.opendaylight.controller.md.sal.binding.api.DataTreeIdentifier;
import org.opendaylight.controller.md.sal.binding.api.DataTreeModification;
import org.opendaylight.controller.md.sal.binding.api.WriteTransaction;
import org.opendaylight.controller.md.sal.binding.impl.BindingDOMDataBrokerAdapter;
import org.opendaylight.controller.md.sal.binding.test.AbstractConcurrentDataBrokerTest;
import org.opendaylight.controller.md.sal.common.api.data.LogicalDatastoreType;
import org.opendaylight.controller.md.sal.test.model.util.ListsBindingUtils;
import org.opendaylight.mdsal.binding.spec.reflect.BindingReflections;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.test.augment.rev140709.TreeComplexUsesAugment;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.test.augment.rev140709.complex.from.grouping.ListViaUsesKey;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.test.list.rev140701.Top;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.test.list.rev140701.TopBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.test.list.rev140701.TwoLevelList;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.test.list.rev140701.two.level.list.TopLevelList;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.test.list.rev140701.two.level.list.TopLevelListBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.test.list.rev140701.two.level.list.TopLevelListKey;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.Identifier;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;
import org.opendaylight.yangtools.yang.binding.YangModuleInfo;

public class DataTreeChangeListenerTest
extends AbstractConcurrentDataBrokerTest {
    private static final InstanceIdentifier<Top> TOP_PATH = InstanceIdentifier.create(Top.class);
    private static final InstanceIdentifier.PathArgument TOP_ARGUMENT = (InstanceIdentifier.PathArgument)TOP_PATH.getPathArguments().iterator().next();
    private static final InstanceIdentifier<TopLevelList> FOO_PATH = ListsBindingUtils.path((TopLevelListKey)ListsBindingUtils.TOP_FOO_KEY);
    private static final InstanceIdentifier.PathArgument FOO_ARGUMENT = (InstanceIdentifier.PathArgument)Iterables.getLast((Iterable)FOO_PATH.getPathArguments());
    private static final TopLevelList FOO_DATA = ListsBindingUtils.topLevelList((TopLevelListKey)ListsBindingUtils.TOP_FOO_KEY, (TreeComplexUsesAugment)ListsBindingUtils.complexUsesAugment((ListViaUsesKey[])new ListViaUsesKey[]{ListsBindingUtils.USES_ONE_KEY}));
    private static final InstanceIdentifier<TopLevelList> BAR_PATH = ListsBindingUtils.path((TopLevelListKey)ListsBindingUtils.TOP_BAR_KEY);
    private static final InstanceIdentifier.PathArgument BAR_ARGUMENT = (InstanceIdentifier.PathArgument)Iterables.getLast((Iterable)BAR_PATH.getPathArguments());
    private static final TopLevelList BAR_DATA = ListsBindingUtils.topLevelList((TopLevelListKey)ListsBindingUtils.TOP_BAR_KEY);
    private static final DataTreeIdentifier<Top> TOP_IDENTIFIER = new DataTreeIdentifier(LogicalDatastoreType.OPERATIONAL, TOP_PATH);
    private static final Top TOP_INITIAL_DATA = ListsBindingUtils.top((TopLevelList[])new TopLevelList[]{FOO_DATA});
    private BindingDOMDataBrokerAdapter dataBrokerImpl;

    @Override
    protected Iterable<YangModuleInfo> getModuleInfos() throws Exception {
        return ImmutableSet.of((Object)BindingReflections.getModuleInfo(TwoLevelList.class), (Object)BindingReflections.getModuleInfo(TreeComplexUsesAugment.class));
    }

    @Before
    public void setupWithDataBroker() {
        this.dataBrokerImpl = (BindingDOMDataBrokerAdapter)this.getDataBroker();
    }

    @Test
    public void testTopLevelListener() throws Exception {
        EventCapturingListener<Top> listener = new EventCapturingListener<Top>();
        this.dataBrokerImpl.registerDataTreeChangeListener(TOP_IDENTIFIER, listener);
        this.createAndVerifyTop(listener);
        this.putTx(BAR_PATH, BAR_DATA).submit().checkedGet();
        DataObjectModification afterBarPutEvent = ((DataTreeModification)Iterables.getOnlyElement(listener.nextEvent())).getRootNode();
        this.verifyModification((DataObjectModification<? extends DataObject>)afterBarPutEvent, TOP_ARGUMENT, DataObjectModification.ModificationType.SUBTREE_MODIFIED);
        DataObjectModification barPutMod = afterBarPutEvent.getModifiedChildListItem(TopLevelList.class, (Identifier)ListsBindingUtils.TOP_BAR_KEY);
        Assert.assertNotNull((Object)barPutMod);
        this.verifyModification((DataObjectModification<? extends DataObject>)barPutMod, BAR_ARGUMENT, DataObjectModification.ModificationType.WRITE);
        this.deleteTx(BAR_PATH).submit().checkedGet();
        DataObjectModification afterBarDeleteEvent = ((DataTreeModification)Iterables.getOnlyElement(listener.nextEvent())).getRootNode();
        this.verifyModification((DataObjectModification<? extends DataObject>)afterBarDeleteEvent, TOP_ARGUMENT, DataObjectModification.ModificationType.SUBTREE_MODIFIED);
        DataObjectModification barDeleteMod = afterBarDeleteEvent.getModifiedChildListItem(TopLevelList.class, (Identifier)ListsBindingUtils.TOP_BAR_KEY);
        this.verifyModification((DataObjectModification<? extends DataObject>)barDeleteMod, BAR_ARGUMENT, DataObjectModification.ModificationType.DELETE);
    }

    @Test
    public void testWildcardedListListener() throws Exception {
        EventCapturingListener listener = new EventCapturingListener();
        DataTreeIdentifier wildcard = new DataTreeIdentifier(LogicalDatastoreType.OPERATIONAL, TOP_PATH.child(TopLevelList.class));
        this.dataBrokerImpl.registerDataTreeChangeListener(wildcard, listener);
        this.putTx(TOP_PATH, TOP_INITIAL_DATA).submit().checkedGet();
        DataTreeModification fooWriteEvent = (DataTreeModification)Iterables.getOnlyElement(listener.nextEvent());
        Assert.assertEquals(FOO_PATH, (Object)fooWriteEvent.getRootPath().getRootIdentifier());
        this.verifyModification((DataObjectModification<? extends DataObject>)fooWriteEvent.getRootNode(), FOO_ARGUMENT, DataObjectModification.ModificationType.WRITE);
        this.putTx(BAR_PATH, BAR_DATA).submit().checkedGet();
        DataTreeModification barWriteEvent = (DataTreeModification)Iterables.getOnlyElement(listener.nextEvent());
        Assert.assertEquals(BAR_PATH, (Object)barWriteEvent.getRootPath().getRootIdentifier());
        this.verifyModification((DataObjectModification<? extends DataObject>)barWriteEvent.getRootNode(), BAR_ARGUMENT, DataObjectModification.ModificationType.WRITE);
        this.deleteTx(BAR_PATH).submit().checkedGet();
        DataTreeModification barDeleteEvent = (DataTreeModification)Iterables.getOnlyElement(listener.nextEvent());
        Assert.assertEquals(BAR_PATH, (Object)barDeleteEvent.getRootPath().getRootIdentifier());
        this.verifyModification((DataObjectModification<? extends DataObject>)barDeleteEvent.getRootNode(), BAR_ARGUMENT, DataObjectModification.ModificationType.DELETE);
    }

    @Test
    public void testWildcardNotificationOfPreexistingData() {
        InstanceIdentifier id = InstanceIdentifier.builder(Top.class).build();
        ArrayList<TopLevelList> list = new ArrayList<TopLevelList>();
        list.add(new TopLevelListBuilder().setName("name").build());
        TopBuilder builder = new TopBuilder().setTopLevelList(list);
        DataBroker dataBroker = this.getDataBroker();
        WriteTransaction writeTransaction = dataBroker.newWriteOnlyTransaction();
        writeTransaction.put(LogicalDatastoreType.OPERATIONAL, id, (DataObject)builder.build());
        DataTreeChangeListenerTest.assertCommit((ListenableFuture<Void>)writeTransaction.submit());
        DataTreeChangeListener listener = (DataTreeChangeListener)Mockito.mock(DataTreeChangeListener.class);
        InstanceIdentifier wildcard = InstanceIdentifier.builder(Top.class).child(TopLevelList.class).build();
        dataBroker.registerDataTreeChangeListener(new DataTreeIdentifier(LogicalDatastoreType.OPERATIONAL, wildcard), listener);
        ((DataTreeChangeListener)Mockito.verify((Object)listener, (VerificationMode)Mockito.timeout((long)1000L))).onDataTreeChanged((Collection)Matchers.anyObject());
    }

    private void createAndVerifyTop(EventCapturingListener<Top> listener) throws Exception {
        this.putTx(TOP_PATH, TOP_INITIAL_DATA).submit().checkedGet();
        Collection<DataTreeModification<Top>> events = listener.nextEvent();
        Assert.assertFalse((String)"Non empty collection should be received.", (boolean)events.isEmpty());
        DataTreeModification initialWrite = (DataTreeModification)Iterables.getOnlyElement(events);
        DataObjectModification initialNode = initialWrite.getRootNode();
        this.verifyModification((DataObjectModification<? extends DataObject>)initialNode, (InstanceIdentifier.PathArgument)TOP_PATH.getPathArguments().iterator().next(), DataObjectModification.ModificationType.WRITE);
        Assert.assertEquals((Object)TOP_INITIAL_DATA, (Object)initialNode.getDataAfter());
    }

    private void verifyModification(DataObjectModification<? extends DataObject> barWrite, InstanceIdentifier.PathArgument pathArg, DataObjectModification.ModificationType eventType) {
        Assert.assertEquals((Object)pathArg.getType(), (Object)barWrite.getDataType());
        Assert.assertEquals((Object)eventType, (Object)barWrite.getModificationType());
        Assert.assertEquals((Object)pathArg, (Object)barWrite.getIdentifier());
    }

    private <T extends DataObject> WriteTransaction putTx(InstanceIdentifier<T> path, T data) {
        WriteTransaction tx = this.dataBrokerImpl.newWriteOnlyTransaction();
        tx.put(LogicalDatastoreType.OPERATIONAL, path, data);
        return tx;
    }

    private WriteTransaction deleteTx(InstanceIdentifier<?> path) {
        WriteTransaction tx = this.dataBrokerImpl.newWriteOnlyTransaction();
        tx.delete(LogicalDatastoreType.OPERATIONAL, path);
        return tx;
    }

    private static final class EventCapturingListener<T extends DataObject>
    implements DataTreeChangeListener<T> {
        private SettableFuture<Collection<DataTreeModification<T>>> changes = SettableFuture.create();

        private EventCapturingListener() {
        }

        public void onDataTreeChanged(Collection<DataTreeModification<T>> modification) {
            this.changes.set(modification);
        }

        Collection<DataTreeModification<T>> nextEvent() throws Exception {
            Collection result = (Collection)this.changes.get(200L, TimeUnit.MILLISECONDS);
            this.changes = SettableFuture.create();
            return result;
        }
    }
}

