/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.md.sal.binding.impl.test;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.junit.Assert;
import org.junit.Test;
import org.opendaylight.controller.md.sal.binding.api.NotificationPublishService;
import org.opendaylight.controller.md.sal.binding.test.AbstractNotificationBrokerTest;
import org.opendaylight.mdsal.binding.spec.reflect.BindingReflections;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.test.list.rev140701.OpendaylightMdsalListTestListener;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.test.list.rev140701.TwoLevelListChanged;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.test.list.rev140701.TwoLevelListChangedBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.test.list.rev140701.two.level.list.TopLevelListBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.test.list.rev140701.two.level.list.TopLevelListKey;
import org.opendaylight.yangtools.concepts.ListenerRegistration;
import org.opendaylight.yangtools.yang.binding.Notification;
import org.opendaylight.yangtools.yang.binding.NotificationListener;
import org.opendaylight.yangtools.yang.binding.YangModuleInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ForwardedNotificationAdapterTest
extends AbstractNotificationBrokerTest {
    private static final Logger LOG = LoggerFactory.getLogger(ForwardedNotificationAdapterTest.class);

    @Override
    protected Iterable<YangModuleInfo> getModuleInfos() throws Exception {
        return ImmutableSet.of((Object)BindingReflections.getModuleInfo(TwoLevelListChanged.class));
    }

    private static TwoLevelListChanged createTestData() {
        TwoLevelListChangedBuilder tb = new TwoLevelListChangedBuilder();
        tb.setTopLevelList((List)ImmutableList.of((Object)new TopLevelListBuilder().withKey(new TopLevelListKey("test")).build()));
        return tb.build();
    }

    @Test
    public void testNotifSubscription() throws InterruptedException {
        CountDownLatch latch = new CountDownLatch(1);
        TwoLevelListChanged testData = ForwardedNotificationAdapterTest.createTestData();
        TestNotifListener testNotifListener = new TestNotifListener(latch);
        ListenerRegistration listenerRegistration = this.getNotificationService().registerNotificationListener((NotificationListener)testNotifListener);
        this.getNotificationPublishService().putNotification((Notification)testData);
        latch.await();
        Assert.assertTrue((testNotifListener.getReceivedNotifications().size() == 1 ? 1 : 0) != 0);
        Assert.assertEquals((Object)testData, (Object)testNotifListener.getReceivedNotifications().get(0));
        listenerRegistration.close();
    }

    @Test
    public void testNotifSubscription2() throws InterruptedException {
        CountDownLatch latch = new CountDownLatch(1);
        TwoLevelListChanged testData = ForwardedNotificationAdapterTest.createTestData();
        TestNotifListener testNotifListener = new TestNotifListener(latch);
        ListenerRegistration listenerRegistration = this.getNotificationService().registerNotificationListener((NotificationListener)testNotifListener);
        try {
            this.getNotificationPublishService().offerNotification((Notification)testData).get(1L, TimeUnit.SECONDS);
        }
        catch (ExecutionException | TimeoutException e) {
            LOG.error("Notification delivery failed", (Throwable)e);
            Assert.fail((String)"notification should be delivered");
        }
        latch.await();
        Assert.assertTrue((testNotifListener.getReceivedNotifications().size() == 1 ? 1 : 0) != 0);
        Assert.assertEquals((Object)testData, (Object)testNotifListener.getReceivedNotifications().get(0));
        listenerRegistration.close();
    }

    @Test
    public void testNotifSubscription3() throws InterruptedException {
        CountDownLatch latch = new CountDownLatch(1);
        TwoLevelListChanged testData = ForwardedNotificationAdapterTest.createTestData();
        TestNotifListener testNotifListener = new TestNotifListener(latch);
        ListenerRegistration listenerRegistration = this.getNotificationService().registerNotificationListener((NotificationListener)testNotifListener);
        Assert.assertNotSame((Object)NotificationPublishService.REJECTED, (Object)this.getNotificationPublishService().offerNotification((Notification)testData, 5, TimeUnit.SECONDS));
        latch.await();
        Assert.assertTrue((testNotifListener.getReceivedNotifications().size() == 1 ? 1 : 0) != 0);
        Assert.assertEquals((Object)testData, (Object)testNotifListener.getReceivedNotifications().get(0));
        listenerRegistration.close();
    }

    private static class TestNotifListener
    implements OpendaylightMdsalListTestListener {
        private final List<TwoLevelListChanged> receivedNotifications = new ArrayList<TwoLevelListChanged>();
        private final CountDownLatch latch;

        TestNotifListener(CountDownLatch latch) {
            this.latch = latch;
        }

        public void onTwoLevelListChanged(TwoLevelListChanged notification) {
            this.receivedNotifications.add(notification);
            this.latch.countDown();
        }

        public List<TwoLevelListChanged> getReceivedNotifications() {
            return this.receivedNotifications;
        }
    }
}

