/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.md.sal.binding.impl.test;

import com.google.common.collect.ImmutableSet;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.junit.Before;
import org.junit.Test;
import org.opendaylight.controller.md.sal.binding.api.DataObjectModification;
import org.opendaylight.controller.md.sal.binding.api.DataTreeModification;
import org.opendaylight.controller.md.sal.binding.api.ReadWriteTransaction;
import org.opendaylight.controller.md.sal.binding.api.WriteTransaction;
import org.opendaylight.controller.md.sal.binding.test.AbstractDataTreeChangeListenerTest;
import org.opendaylight.controller.md.sal.common.api.data.LogicalDatastoreType;
import org.opendaylight.controller.md.sal.test.model.util.ListsBindingUtils;
import org.opendaylight.mdsal.binding.spec.reflect.BindingReflections;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.test.list.rev140701.Top;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.test.list.rev140701.two.level.list.TopLevelList;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.test.list.rev140701.two.level.list.TopLevelListBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.test.list.rev140701.two.level.list.TopLevelListKey;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.Identifier;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;
import org.opendaylight.yangtools.yang.binding.YangModuleInfo;

public class ListInsertionDataChangeListenerTest
extends AbstractDataTreeChangeListenerTest {
    private static final InstanceIdentifier<Top> TOP = InstanceIdentifier.create(Top.class);
    private static final InstanceIdentifier<TopLevelList> WILDCARDED = TOP.child(TopLevelList.class);
    private static final InstanceIdentifier<TopLevelList> TOP_FOO = TOP.child(TopLevelList.class, (Identifier)ListsBindingUtils.TOP_FOO_KEY);
    private static final InstanceIdentifier<TopLevelList> TOP_BAR = TOP.child(TopLevelList.class, (Identifier)ListsBindingUtils.TOP_BAR_KEY);

    @Override
    protected Iterable<YangModuleInfo> getModuleInfos() throws Exception {
        return ImmutableSet.of((Object)BindingReflections.getModuleInfo(Top.class));
    }

    @Before
    public void setupWithDataBroker() {
        WriteTransaction initialTx = this.getDataBroker().newWriteOnlyTransaction();
        initialTx.put(LogicalDatastoreType.CONFIGURATION, TOP, (DataObject)ListsBindingUtils.top((TopLevelList[])new TopLevelList[]{ListsBindingUtils.topLevelList((TopLevelListKey)ListsBindingUtils.TOP_FOO_KEY)}));
        ListInsertionDataChangeListenerTest.assertCommit((ListenableFuture<Void>)initialTx.submit());
    }

    @Test
    public void replaceTopNodeSubtreeListeners() {
        TopLevelList topBar = ListsBindingUtils.topLevelList((TopLevelListKey)ListsBindingUtils.TOP_BAR_KEY);
        Top top = ListsBindingUtils.top((TopLevelList[])new TopLevelList[]{topBar});
        TopLevelList topFoo = ListsBindingUtils.topLevelList((TopLevelListKey)ListsBindingUtils.TOP_FOO_KEY);
        AbstractDataTreeChangeListenerTest.TestListener<Top> topListener = this.createListener(LogicalDatastoreType.CONFIGURATION, TOP, ListInsertionDataChangeListenerTest.added(TOP, ListsBindingUtils.top((TopLevelList[])new TopLevelList[]{ListsBindingUtils.topLevelList((TopLevelListKey)ListsBindingUtils.TOP_FOO_KEY)})), ListInsertionDataChangeListenerTest.replaced(TOP, ListsBindingUtils.top((TopLevelList[])new TopLevelList[]{topFoo}), top));
        AbstractDataTreeChangeListenerTest.TestListener<TopLevelList> allListener = this.createListener(LogicalDatastoreType.CONFIGURATION, WILDCARDED, ListInsertionDataChangeListenerTest.added(TOP_FOO, topFoo), ListInsertionDataChangeListenerTest.added(TOP_BAR, topBar), ListInsertionDataChangeListenerTest.deleted(TOP_FOO, topFoo));
        AbstractDataTreeChangeListenerTest.TestListener<TopLevelList> fooListener = this.createListener(LogicalDatastoreType.CONFIGURATION, TOP_FOO, ListInsertionDataChangeListenerTest.added(TOP_FOO, topFoo), ListInsertionDataChangeListenerTest.deleted(TOP_FOO, topFoo));
        AbstractDataTreeChangeListenerTest.TestListener<TopLevelList> barListener = this.createListener(LogicalDatastoreType.CONFIGURATION, TOP_BAR, ListInsertionDataChangeListenerTest.added(TOP_BAR, topBar));
        ReadWriteTransaction writeTx = this.getDataBroker().newReadWriteTransaction();
        writeTx.put(LogicalDatastoreType.CONFIGURATION, TOP, (DataObject)top);
        ListInsertionDataChangeListenerTest.assertCommit((ListenableFuture<Void>)writeTx.submit());
        topListener.verify();
        allListener.verify();
        fooListener.verify();
        barListener.verify();
    }

    @Test
    public void mergeTopNodeSubtreeListeners() {
        TopLevelList topBar = ListsBindingUtils.topLevelList((TopLevelListKey)ListsBindingUtils.TOP_BAR_KEY);
        TopLevelList topFoo = ListsBindingUtils.topLevelList((TopLevelListKey)ListsBindingUtils.TOP_FOO_KEY);
        AbstractDataTreeChangeListenerTest.TestListener<Top> topListener = this.createListener(LogicalDatastoreType.CONFIGURATION, TOP, ListInsertionDataChangeListenerTest.added(TOP, ListsBindingUtils.top((TopLevelList[])new TopLevelList[]{ListsBindingUtils.topLevelList((TopLevelListKey)ListsBindingUtils.TOP_FOO_KEY)})), this.topSubtreeModified(topFoo, topBar));
        AbstractDataTreeChangeListenerTest.TestListener<TopLevelList> allListener = this.createListener(LogicalDatastoreType.CONFIGURATION, WILDCARDED, ListInsertionDataChangeListenerTest.added(TOP_FOO, topFoo), ListInsertionDataChangeListenerTest.added(TOP_BAR, topBar));
        AbstractDataTreeChangeListenerTest.TestListener<TopLevelList> fooListener = this.createListener(LogicalDatastoreType.CONFIGURATION, TOP_FOO, ListInsertionDataChangeListenerTest.added(TOP_FOO, topFoo));
        AbstractDataTreeChangeListenerTest.TestListener<TopLevelList> barListener = this.createListener(LogicalDatastoreType.CONFIGURATION, TOP_BAR, ListInsertionDataChangeListenerTest.added(TOP_BAR, topBar));
        ReadWriteTransaction writeTx = this.getDataBroker().newReadWriteTransaction();
        writeTx.merge(LogicalDatastoreType.CONFIGURATION, TOP, (DataObject)ListsBindingUtils.top((TopLevelList[])new TopLevelList[]{ListsBindingUtils.topLevelList((TopLevelListKey)ListsBindingUtils.TOP_BAR_KEY)}));
        ListInsertionDataChangeListenerTest.assertCommit((ListenableFuture<Void>)writeTx.submit());
        topListener.verify();
        allListener.verify();
        fooListener.verify();
        barListener.verify();
    }

    @Test
    public void putTopBarNodeSubtreeListeners() {
        TopLevelList topBar = ListsBindingUtils.topLevelList((TopLevelListKey)ListsBindingUtils.TOP_BAR_KEY);
        TopLevelList topFoo = ListsBindingUtils.topLevelList((TopLevelListKey)ListsBindingUtils.TOP_FOO_KEY);
        AbstractDataTreeChangeListenerTest.TestListener<Top> topListener = this.createListener(LogicalDatastoreType.CONFIGURATION, TOP, ListInsertionDataChangeListenerTest.added(TOP, ListsBindingUtils.top((TopLevelList[])new TopLevelList[]{ListsBindingUtils.topLevelList((TopLevelListKey)ListsBindingUtils.TOP_FOO_KEY)})), this.topSubtreeModified(topFoo, topBar));
        AbstractDataTreeChangeListenerTest.TestListener<TopLevelList> allListener = this.createListener(LogicalDatastoreType.CONFIGURATION, WILDCARDED, ListInsertionDataChangeListenerTest.added(TOP_FOO, topFoo), ListInsertionDataChangeListenerTest.added(TOP_BAR, topBar));
        AbstractDataTreeChangeListenerTest.TestListener<TopLevelList> fooListener = this.createListener(LogicalDatastoreType.CONFIGURATION, TOP_FOO, ListInsertionDataChangeListenerTest.added(TOP_FOO, topFoo));
        AbstractDataTreeChangeListenerTest.TestListener<TopLevelList> barListener = this.createListener(LogicalDatastoreType.CONFIGURATION, TOP_BAR, ListInsertionDataChangeListenerTest.added(TOP_BAR, topBar));
        ReadWriteTransaction writeTx = this.getDataBroker().newReadWriteTransaction();
        writeTx.put(LogicalDatastoreType.CONFIGURATION, TOP_BAR, (DataObject)ListsBindingUtils.topLevelList((TopLevelListKey)ListsBindingUtils.TOP_BAR_KEY));
        ListInsertionDataChangeListenerTest.assertCommit((ListenableFuture<Void>)writeTx.submit());
        topListener.verify();
        allListener.verify();
        fooListener.verify();
        barListener.verify();
    }

    @Test
    public void mergeTopBarNodeSubtreeListeners() {
        TopLevelList topBar = ListsBindingUtils.topLevelList((TopLevelListKey)ListsBindingUtils.TOP_BAR_KEY);
        TopLevelList topFoo = ListsBindingUtils.topLevelList((TopLevelListKey)ListsBindingUtils.TOP_FOO_KEY);
        AbstractDataTreeChangeListenerTest.TestListener<Top> topListener = this.createListener(LogicalDatastoreType.CONFIGURATION, TOP, ListInsertionDataChangeListenerTest.added(TOP, ListsBindingUtils.top((TopLevelList[])new TopLevelList[]{ListsBindingUtils.topLevelList((TopLevelListKey)ListsBindingUtils.TOP_FOO_KEY)})), this.topSubtreeModified(topFoo, topBar));
        AbstractDataTreeChangeListenerTest.TestListener<TopLevelList> allListener = this.createListener(LogicalDatastoreType.CONFIGURATION, WILDCARDED, ListInsertionDataChangeListenerTest.added(TOP_FOO, topFoo), ListInsertionDataChangeListenerTest.added(TOP_BAR, topBar));
        AbstractDataTreeChangeListenerTest.TestListener<TopLevelList> fooListener = this.createListener(LogicalDatastoreType.CONFIGURATION, TOP_FOO, ListInsertionDataChangeListenerTest.added(TOP_FOO, topFoo));
        AbstractDataTreeChangeListenerTest.TestListener<TopLevelList> barListener = this.createListener(LogicalDatastoreType.CONFIGURATION, TOP_BAR, ListInsertionDataChangeListenerTest.added(TOP_BAR, topBar));
        ReadWriteTransaction writeTx = this.getDataBroker().newReadWriteTransaction();
        writeTx.merge(LogicalDatastoreType.CONFIGURATION, TOP_BAR, (DataObject)ListsBindingUtils.topLevelList((TopLevelListKey)ListsBindingUtils.TOP_BAR_KEY));
        ListInsertionDataChangeListenerTest.assertCommit((ListenableFuture<Void>)writeTx.submit());
        topListener.verify();
        allListener.verify();
        fooListener.verify();
        barListener.verify();
    }

    private Function<DataTreeModification<Top>, Boolean> topSubtreeModified(TopLevelList topFoo, TopLevelList topBar) {
        return ListInsertionDataChangeListenerTest.match(DataObjectModification.ModificationType.SUBTREE_MODIFIED, TOP, dataBefore -> Objects.equals(ListsBindingUtils.top((TopLevelList[])new TopLevelList[]{topFoo}), dataBefore), dataAfter -> {
            HashSet expList = new HashSet(ListsBindingUtils.top((TopLevelList[])new TopLevelList[]{topBar, topFoo}).getTopLevelList());
            Set actualList = dataAfter.getTopLevelList().stream().map(list -> new TopLevelListBuilder(list).build()).collect(Collectors.toSet());
            return expList.equals(actualList);
        });
    }
}

