/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.md.sal.binding.compat;

import java.util.concurrent.ExecutorService;
import org.opendaylight.controller.md.sal.binding.api.NotificationPublishService;
import org.opendaylight.controller.md.sal.binding.api.NotificationService;
import org.opendaylight.controller.md.sal.binding.compat.HeliumNotificationServiceAdapter;
import org.opendaylight.controller.sal.binding.api.NotificationProviderService;
import org.opendaylight.yangtools.concepts.ListenerRegistration;
import org.opendaylight.yangtools.yang.binding.Notification;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HeliumNotificationProviderServiceAdapter
extends HeliumNotificationServiceAdapter
implements NotificationProviderService {
    private static final Logger LOG = LoggerFactory.getLogger(HeliumNotificationProviderServiceAdapter.class);
    private final NotificationPublishService notificationPublishService;

    public HeliumNotificationProviderServiceAdapter(NotificationPublishService notificationPublishService, NotificationService notificationService) {
        super(notificationService);
        this.notificationPublishService = notificationPublishService;
    }

    public void publish(Notification notification) {
        try {
            this.notificationPublishService.putNotification(notification);
        }
        catch (InterruptedException e) {
            LOG.error("Notification publication was interupted: " + e);
        }
    }

    public void publish(Notification notification, ExecutorService executor) {
        try {
            this.notificationPublishService.putNotification(notification);
        }
        catch (InterruptedException e) {
            LOG.error("Notification publication was interupted: " + e);
        }
    }

    public ListenerRegistration<NotificationProviderService.NotificationInterestListener> registerInterestListener(NotificationProviderService.NotificationInterestListener interestListener) {
        throw new UnsupportedOperationException("InterestListener is not supported.");
    }

    @Override
    public void close() throws Exception {
    }
}

