/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.md.sal.binding.compat;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.EventListener;
import java.util.Iterator;
import java.util.Set;
import org.opendaylight.controller.md.sal.binding.compat.FunctionalNotificationListenerAdapter;
import org.opendaylight.controller.md.sal.binding.compat.HeliumNotificationProviderServiceAdapter;
import org.opendaylight.controller.md.sal.binding.impl.BindingDOMNotificationPublishServiceAdapter;
import org.opendaylight.controller.md.sal.binding.impl.BindingDOMNotificationServiceAdapter;
import org.opendaylight.controller.md.sal.binding.impl.BindingToNormalizedNodeCodec;
import org.opendaylight.controller.md.sal.dom.api.DOMNotificationService;
import org.opendaylight.controller.md.sal.dom.spi.DOMNotificationSubscriptionListener;
import org.opendaylight.controller.md.sal.dom.spi.DOMNotificationSubscriptionListenerRegistry;
import org.opendaylight.controller.sal.binding.api.NotificationListener;
import org.opendaylight.controller.sal.binding.api.NotificationProviderService;
import org.opendaylight.mdsal.binding.dom.codec.api.BindingNormalizedNodeSerializer;
import org.opendaylight.mdsal.binding.spec.reflect.BindingReflections;
import org.opendaylight.yangtools.concepts.AbstractListenerRegistration;
import org.opendaylight.yangtools.concepts.ListenerRegistration;
import org.opendaylight.yangtools.util.ListenerRegistry;
import org.opendaylight.yangtools.yang.binding.Notification;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.model.api.SchemaPath;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HeliumNotificationProviderServiceWithInterestListeners
extends HeliumNotificationProviderServiceAdapter {
    private static final Logger LOG = LoggerFactory.getLogger(HeliumNotificationProviderServiceWithInterestListeners.class);
    private final ListenerRegistry<NotificationProviderService.NotificationInterestListener> interestListeners = ListenerRegistry.create();
    private final ListenerRegistration<Listener> domListener;
    private final DOMNotificationService domService;
    private final BindingToNormalizedNodeCodec codec;

    public HeliumNotificationProviderServiceWithInterestListeners(BindingDOMNotificationPublishServiceAdapter publishService, BindingDOMNotificationServiceAdapter listenService, DOMNotificationSubscriptionListenerRegistry registry) {
        super(publishService, listenService);
        this.codec = publishService.getCodecRegistry();
        this.domListener = registry.registerSubscriptionListener((DOMNotificationSubscriptionListener)new Listener());
        this.domService = listenService.getDomService();
    }

    @Override
    public ListenerRegistration<NotificationProviderService.NotificationInterestListener> registerInterestListener(NotificationProviderService.NotificationInterestListener listener) {
        this.notifyListener(listener, this.translate(((Listener)this.domListener.getInstance()).getAllObserved()));
        return this.interestListeners.register((EventListener)listener);
    }

    private Set<Class<? extends Notification>> translate(Set<SchemaPath> added) {
        return this.codec.getNotificationClasses(added);
    }

    private void notifyAllListeners(Set<SchemaPath> added) {
        Iterator listeners = this.interestListeners.iterator();
        if (listeners.hasNext()) {
            Set<Class<? extends Notification>> baEvent = this.translate(added);
            while (listeners.hasNext()) {
                NotificationProviderService.NotificationInterestListener listenerRef = (NotificationProviderService.NotificationInterestListener)((ListenerRegistration)listeners.next()).getInstance();
                try {
                    this.notifyListener(listenerRef, baEvent);
                }
                catch (RuntimeException e) {
                    LOG.warn("Unhandled exception during invoking listener {}", (Object)e, (Object)listenerRef);
                }
            }
        }
    }

    @Override
    public <T extends Notification> ListenerRegistration<NotificationListener<T>> registerNotificationListener(Class<T> type, NotificationListener<T> listener) {
        FunctionalNotificationListenerAdapter<T> adapter = new FunctionalNotificationListenerAdapter<T>((BindingNormalizedNodeSerializer)this.codec, type, listener);
        SchemaPath domType = SchemaPath.create((boolean)true, (QName[])new QName[]{BindingReflections.findQName(type)});
        final ListenerRegistration domReg = this.domService.registerNotificationListener(adapter, new SchemaPath[]{domType});
        return new AbstractListenerRegistration<NotificationListener<T>>(listener){

            protected void removeRegistration() {
                domReg.close();
            }
        };
    }

    private void notifyListener(NotificationProviderService.NotificationInterestListener listener, Set<Class<? extends Notification>> baEvent) {
        for (Class<? extends Notification> event : baEvent) {
            listener.onNotificationSubscribtion(event);
        }
    }

    @Override
    public void close() throws Exception {
        super.close();
        this.domListener.close();
    }

    private final class Listener
    implements DOMNotificationSubscriptionListener {
        private volatile Set<SchemaPath> allObserved = Collections.emptySet();

        private Listener() {
        }

        public void onSubscriptionChanged(Set<SchemaPath> currentTypes) {
            ImmutableSet added = Sets.difference(currentTypes, this.allObserved).immutableCopy();
            HeliumNotificationProviderServiceWithInterestListeners.this.notifyAllListeners((Set)added);
            this.allObserved = Sets.union(this.allObserved, (Set)added).immutableCopy();
        }

        Set<SchemaPath> getAllObserved() {
            return this.allObserved;
        }
    }
}

