/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.md.sal.binding.impl;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.opendaylight.controller.md.sal.binding.api.ActionProviderService;
import org.opendaylight.controller.md.sal.binding.api.ActionService;
import org.opendaylight.controller.md.sal.binding.api.BindingService;
import org.opendaylight.controller.md.sal.binding.api.DataBroker;
import org.opendaylight.controller.md.sal.binding.api.NotificationPublishService;
import org.opendaylight.controller.md.sal.binding.api.NotificationService;
import org.opendaylight.controller.md.sal.binding.impl.BindingDOMAdapterBuilder;
import org.opendaylight.controller.md.sal.binding.impl.BindingDOMDataBrokerAdapter;
import org.opendaylight.controller.md.sal.binding.impl.BindingDOMNotificationPublishServiceAdapter;
import org.opendaylight.controller.md.sal.binding.impl.BindingDOMNotificationServiceAdapter;
import org.opendaylight.controller.md.sal.binding.impl.BindingDOMRpcServiceAdapter;
import org.opendaylight.controller.md.sal.binding.impl.BindingToNormalizedNodeCodec;
import org.opendaylight.controller.md.sal.binding.impl.ControllerActionProviderServiceAdapter;
import org.opendaylight.controller.md.sal.binding.impl.ControllerActionServiceAdapter;
import org.opendaylight.controller.md.sal.binding.spi.AdapterBuilder;
import org.opendaylight.controller.md.sal.binding.spi.AdapterLoader;
import org.opendaylight.controller.md.sal.dom.api.DOMService;
import org.opendaylight.controller.sal.binding.api.RpcConsumerRegistry;

public abstract class BindingDOMAdapterLoader
extends AdapterLoader<BindingService, DOMService> {
    private static final Map<Class<?>, BindingDOMAdapterBuilder.Factory<?>> FACTORIES = ImmutableMap.builder().put(NotificationService.class, BindingDOMNotificationServiceAdapter.BUILDER_FACTORY).put(NotificationPublishService.class, BindingDOMNotificationPublishServiceAdapter.BUILDER_FACTORY).put(DataBroker.class, BindingDOMDataBrokerAdapter.BUILDER_FACTORY).put(RpcConsumerRegistry.class, BindingDOMRpcServiceAdapter.BUILDER_FACTORY).put(ActionProviderService.class, ControllerActionProviderServiceAdapter.BUILDER_FACTORY).put(ActionService.class, ControllerActionServiceAdapter.BUILDER_FACTORY).build();
    private final BindingToNormalizedNodeCodec codec;

    public BindingDOMAdapterLoader(BindingToNormalizedNodeCodec codec) {
        this.codec = codec;
    }

    @Override
    protected final AdapterBuilder<? extends BindingService, DOMService> createBuilder(Class<? extends BindingService> key) {
        BindingDOMAdapterBuilder.Factory<?> factory = FACTORIES.get(key);
        Preconditions.checkArgument((factory != null ? 1 : 0) != 0, (String)"Unsupported service type %s", key);
        BindingDOMAdapterBuilder<?> builder = factory.newBuilder();
        builder.setCodec(this.codec);
        return builder;
    }
}

