/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.md.sal.binding.impl;

import com.google.common.base.Optional;
import org.opendaylight.controller.md.sal.binding.api.MountPointService;
import org.opendaylight.controller.md.sal.binding.impl.BindingDOMMountPointServiceAdapter;
import org.opendaylight.controller.md.sal.binding.impl.BindingToNormalizedNodeCodec;
import org.opendaylight.controller.md.sal.dom.api.DOMMountPointService;
import org.opendaylight.mdsal.dom.api.DOMMountPointListener;
import org.opendaylight.yangtools.concepts.ListenerRegistration;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.impl.codec.DeserializationException;

final class BindingDOMMountPointListenerAdapter<T extends MountPointService.MountPointListener>
implements ListenerRegistration<T>,
DOMMountPointListener {
    private final T listener;
    private final ListenerRegistration<DOMMountPointListener> registration;
    private final BindingToNormalizedNodeCodec codec;

    BindingDOMMountPointListenerAdapter(T listener, BindingToNormalizedNodeCodec codec, DOMMountPointService mountService) {
        this.listener = listener;
        this.codec = codec;
        this.registration = mountService.registerProvisionListener((DOMMountPointListener)this);
    }

    public T getInstance() {
        return this.listener;
    }

    public void close() {
        this.registration.close();
    }

    public void onMountPointCreated(YangInstanceIdentifier path) {
        try {
            InstanceIdentifier<DataObject> bindingPath = this.toBinding(path);
            this.listener.onMountPointCreated(bindingPath);
        }
        catch (DeserializationException e) {
            BindingDOMMountPointServiceAdapter.LOG.error("Unable to translate mountPoint path {}. Omitting event.", (Object)path, (Object)e);
        }
    }

    private InstanceIdentifier<? extends DataObject> toBinding(YangInstanceIdentifier path) throws DeserializationException {
        Optional instanceIdentifierOptional = this.codec.toBinding(path);
        if (instanceIdentifierOptional.isPresent()) {
            return (InstanceIdentifier)instanceIdentifierOptional.get();
        }
        throw new DeserializationException("Deserialization unsuccessful, " + instanceIdentifierOptional);
    }

    public void onMountPointRemoved(YangInstanceIdentifier path) {
        try {
            InstanceIdentifier<DataObject> bindingPath = this.toBinding(path);
            this.listener.onMountPointRemoved(bindingPath);
        }
        catch (DeserializationException e) {
            BindingDOMMountPointServiceAdapter.LOG.error("Unable to translate mountPoint path {}. Omitting event.", (Object)path, (Object)e);
        }
    }
}

