/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.md.sal.binding.impl;

import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.FluentFuture;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.MoreExecutors;
import org.opendaylight.controller.md.sal.binding.api.BindingTransactionChain;
import org.opendaylight.controller.md.sal.binding.api.ReadOnlyTransaction;
import org.opendaylight.controller.md.sal.binding.api.ReadWriteTransaction;
import org.opendaylight.controller.md.sal.binding.api.WriteTransaction;
import org.opendaylight.controller.md.sal.binding.impl.BindingDOMReadTransactionAdapter;
import org.opendaylight.controller.md.sal.binding.impl.BindingDOMReadWriteTransactionAdapter;
import org.opendaylight.controller.md.sal.binding.impl.BindingDOMWriteTransactionAdapter;
import org.opendaylight.controller.md.sal.binding.impl.BindingToNormalizedNodeCodec;
import org.opendaylight.controller.md.sal.common.api.data.AsyncTransaction;
import org.opendaylight.controller.md.sal.common.api.data.TransactionChain;
import org.opendaylight.controller.md.sal.common.api.data.TransactionChainListener;
import org.opendaylight.controller.md.sal.dom.api.DOMDataBroker;
import org.opendaylight.controller.md.sal.dom.api.DOMDataReadOnlyTransaction;
import org.opendaylight.controller.md.sal.dom.api.DOMDataReadWriteTransaction;
import org.opendaylight.controller.md.sal.dom.api.DOMDataWriteTransaction;
import org.opendaylight.controller.md.sal.dom.api.DOMTransactionChain;
import org.opendaylight.mdsal.common.api.CommitInfo;
import org.opendaylight.yangtools.concepts.Delegator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class BindingDOMTransactionChainAdapter
implements BindingTransactionChain,
Delegator<DOMTransactionChain> {
    private static final Logger LOG = LoggerFactory.getLogger(BindingDOMTransactionChainAdapter.class);
    private final DOMTransactionChain delegate;
    private final BindingToNormalizedNodeCodec codec;
    private final DelegateChainListener domListener;
    private final TransactionChainListener bindingListener;

    BindingDOMTransactionChainAdapter(DOMDataBroker chainFactory, BindingToNormalizedNodeCodec codec, TransactionChainListener listener) {
        Preconditions.checkNotNull((Object)chainFactory, (Object)"DOM Transaction chain factory must not be null");
        this.domListener = new DelegateChainListener();
        this.bindingListener = listener;
        this.delegate = chainFactory.createTransactionChain((TransactionChainListener)this.domListener);
        this.codec = codec;
    }

    public DOMTransactionChain getDelegate() {
        return this.delegate;
    }

    public ReadOnlyTransaction newReadOnlyTransaction() {
        DOMDataReadOnlyTransaction delegateTx = this.delegate.newReadOnlyTransaction();
        return new BindingDOMReadTransactionAdapter(delegateTx, this.codec);
    }

    public ReadWriteTransaction newReadWriteTransaction() {
        DOMDataReadWriteTransaction delegateTx = this.delegate.newReadWriteTransaction();
        return new BindingDOMReadWriteTransactionAdapter(delegateTx, this.codec){

            @Override
            public FluentFuture<? extends CommitInfo> commit() {
                return BindingDOMTransactionChainAdapter.this.listenForFailure(this, (FluentFuture<? extends CommitInfo>)super.commit());
            }
        };
    }

    public WriteTransaction newWriteOnlyTransaction() {
        DOMDataWriteTransaction delegateTx = this.delegate.newWriteOnlyTransaction();
        return new BindingDOMWriteTransactionAdapter<DOMDataWriteTransaction>(delegateTx, this.codec){

            @Override
            public FluentFuture<? extends CommitInfo> commit() {
                return BindingDOMTransactionChainAdapter.this.listenForFailure(this, (FluentFuture<? extends CommitInfo>)super.commit());
            }
        };
    }

    private FluentFuture<? extends CommitInfo> listenForFailure(final WriteTransaction tx, FluentFuture<? extends CommitInfo> future) {
        future.addCallback((FutureCallback)new FutureCallback<CommitInfo>(){

            public void onFailure(Throwable ex) {
                BindingDOMTransactionChainAdapter.this.failTransactionChain(tx, ex);
            }

            public void onSuccess(CommitInfo result) {
            }
        }, MoreExecutors.directExecutor());
        return future;
    }

    private void failTransactionChain(WriteTransaction tx, Throwable ex) {
        this.bindingListener.onTransactionChainFailed((TransactionChain)this, (AsyncTransaction)tx, ex);
    }

    public void close() {
        this.delegate.close();
    }

    private final class DelegateChainListener
    implements TransactionChainListener {
        private DelegateChainListener() {
        }

        public void onTransactionChainFailed(TransactionChain<?, ?> chain, AsyncTransaction<?, ?> transaction, Throwable cause) {
            Preconditions.checkState((boolean)BindingDOMTransactionChainAdapter.this.delegate.equals(chain), (String)"Illegal state - listener for %s was invoked for incorrect chain %s.", (Object)BindingDOMTransactionChainAdapter.this.delegate, chain);
            LOG.debug("Transaction chain {} failed. Failed DOM Transaction {}", new Object[]{this, transaction, cause});
        }

        public void onTransactionChainSuccessful(TransactionChain<?, ?> chain) {
            Preconditions.checkState((boolean)BindingDOMTransactionChainAdapter.this.delegate.equals(chain), (String)"Illegal state - listener for %s was invoked for incorrect chain %s.", (Object)BindingDOMTransactionChainAdapter.this.delegate, chain);
            BindingDOMTransactionChainAdapter.this.bindingListener.onTransactionChainSuccessful((TransactionChain)BindingDOMTransactionChainAdapter.this);
        }
    }
}

