/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.md.sal.binding.impl;

import com.google.common.collect.ImmutableBiMap;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.Map;
import javax.annotation.Nonnull;
import org.opendaylight.controller.md.sal.common.impl.util.compat.DataNormalizationException;
import org.opendaylight.controller.md.sal.common.impl.util.compat.DataNormalizationOperation;
import org.opendaylight.controller.md.sal.common.impl.util.compat.DataNormalizer;
import org.opendaylight.mdsal.binding.dom.codec.api.BindingCodecTreeNode;
import org.opendaylight.mdsal.binding.dom.codec.impl.BindingNormalizedNodeCodecRegistry;
import org.opendaylight.mdsal.binding.generator.api.ClassLoadingStrategy;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;
import org.opendaylight.yangtools.yang.binding.RpcService;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.model.api.RpcDefinition;
import org.opendaylight.yangtools.yang.model.api.SchemaContext;

@SuppressFBWarnings(value={"NM_SAME_SIMPLE_NAME_AS_SUPERCLASS"}, justification="Migration path")
public class BindingToNormalizedNodeCodec
extends org.opendaylight.mdsal.binding.dom.adapter.BindingToNormalizedNodeCodec {
    private DataNormalizer legacyToNormalized = null;

    public BindingToNormalizedNodeCodec(ClassLoadingStrategy classLoadingStrategy, BindingNormalizedNodeCodecRegistry codecRegistry) {
        super(classLoadingStrategy, codecRegistry);
    }

    public BindingToNormalizedNodeCodec(ClassLoadingStrategy classLoadingStrategy, BindingNormalizedNodeCodecRegistry codecRegistry, boolean waitForSchema) {
        super(classLoadingStrategy, codecRegistry, waitForSchema);
    }

    DataNormalizer getDataNormalizer() {
        return this.legacyToNormalized;
    }

    public YangInstanceIdentifier toYangInstanceIdentifierBlocking(InstanceIdentifier<? extends DataObject> binding) {
        return super.toYangInstanceIdentifierBlocking(binding);
    }

    public YangInstanceIdentifier toYangInstanceIdentifierCached(InstanceIdentifier<?> binding) {
        return super.toYangInstanceIdentifierCached(binding);
    }

    public void onGlobalContextUpdated(SchemaContext schemaContext) {
        this.legacyToNormalized = new DataNormalizer(schemaContext);
        super.onGlobalContextUpdated(schemaContext);
    }

    public NormalizedNode<?, ?> getDefaultNodeFor(YangInstanceIdentifier path) {
        Iterator iterator = path.getPathArguments().iterator();
        DataNormalizationOperation currentOp = this.legacyToNormalized.getRootOperation();
        while (iterator.hasNext()) {
            YangInstanceIdentifier.PathArgument currentArg = (YangInstanceIdentifier.PathArgument)iterator.next();
            try {
                currentOp = currentOp.getChild(currentArg);
            }
            catch (DataNormalizationException e) {
                throw new IllegalArgumentException(String.format("Invalid child encountered in path %s", path), e);
            }
        }
        return currentOp.createDefault(path.getLastPathArgument());
    }

    public ImmutableBiMap<Method, RpcDefinition> getRpcMethodToSchema(Class<? extends RpcService> key) {
        return super.getRpcMethodToSchema(key);
    }

    @Nonnull
    public Map.Entry<InstanceIdentifier<?>, BindingCodecTreeNode<?>> getSubtreeCodec(YangInstanceIdentifier domIdentifier) {
        return super.getSubtreeCodec(domIdentifier);
    }
}

