/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.md.sal.binding.impl;

import com.google.common.base.Throwables;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Method;
import org.opendaylight.controller.md.sal.binding.impl.ContextReferenceExtractor;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;

final class DirectGetterRouteContextExtractor
extends ContextReferenceExtractor {
    private static final MethodHandles.Lookup PUBLIC_LOOKUP = MethodHandles.publicLookup();
    private final MethodHandle handle;

    private DirectGetterRouteContextExtractor(MethodHandle rawHandle) {
        this.handle = rawHandle.asType(MethodType.methodType(InstanceIdentifier.class, DataObject.class));
    }

    static ContextReferenceExtractor create(Method getterMethod) throws IllegalAccessException {
        MethodHandle getterHandle = PUBLIC_LOOKUP.unreflect(getterMethod);
        return new DirectGetterRouteContextExtractor(getterHandle);
    }

    @Override
    InstanceIdentifier<?> extract(DataObject obj) {
        try {
            return this.handle.invokeExact(obj);
        }
        catch (Throwable e) {
            throw Throwables.propagate((Throwable)e);
        }
    }
}

