/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.md.sal.binding.impl;

import com.google.common.base.Throwables;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Method;
import org.opendaylight.controller.md.sal.binding.impl.ContextReferenceExtractor;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;

final class GetValueRouteContextExtractor
extends ContextReferenceExtractor {
    private static final MethodHandles.Lookup PUBLIC_LOOKUP = MethodHandles.publicLookup();
    private final MethodHandle contextHandle;
    private final MethodHandle valueHandle;

    private GetValueRouteContextExtractor(MethodHandle rawContextHandle, MethodHandle rawValueHandle) {
        this.contextHandle = rawContextHandle.asType(MethodType.methodType(Object.class, DataObject.class));
        this.valueHandle = rawValueHandle.asType(MethodType.methodType(InstanceIdentifier.class, Object.class));
    }

    public static ContextReferenceExtractor create(Method contextGetter, Method getValueMethod) throws IllegalAccessException {
        MethodHandle rawContextHandle = PUBLIC_LOOKUP.unreflect(contextGetter);
        MethodHandle rawValueHandle = PUBLIC_LOOKUP.unreflect(getValueMethod);
        return new GetValueRouteContextExtractor(rawContextHandle, rawValueHandle);
    }

    @Override
    InstanceIdentifier<?> extract(DataObject obj) {
        try {
            Object ctx = this.contextHandle.invokeExact(obj);
            if (ctx != null) {
                return this.valueHandle.invokeExact(ctx);
            }
            return null;
        }
        catch (Throwable e) {
            throw Throwables.propagate((Throwable)e);
        }
    }
}

