/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.md.sal.binding.impl;

import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import org.opendaylight.mdsal.binding.dom.adapter.BindingDataAware;
import org.opendaylight.mdsal.binding.dom.codec.api.BindingNormalizedNodeSerializer;
import org.opendaylight.yangtools.yang.binding.DataContainer;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.ContainerNode;
import org.opendaylight.yangtools.yang.data.api.schema.DataContainerChild;
import org.opendaylight.yangtools.yang.data.api.schema.LeafNode;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.model.api.SchemaPath;

class LazySerializedContainerNode
implements ContainerNode,
BindingDataAware {
    private final YangInstanceIdentifier.NodeIdentifier identifier;
    private final DataObject bindingData;
    private BindingNormalizedNodeSerializer registry;
    private ContainerNode domData;

    private LazySerializedContainerNode(QName identifier, DataObject binding, BindingNormalizedNodeSerializer registry) {
        this.identifier = new YangInstanceIdentifier.NodeIdentifier(identifier);
        this.bindingData = binding;
        this.registry = registry;
        this.domData = null;
    }

    static NormalizedNode<?, ?> create(SchemaPath rpcName, DataObject data, BindingNormalizedNodeSerializer codec) {
        return new LazySerializedContainerNode(rpcName.getLastComponent(), data, codec);
    }

    static NormalizedNode<?, ?> withContextRef(SchemaPath rpcName, DataObject data, LeafNode<?> contextRef, BindingNormalizedNodeSerializer codec) {
        return new WithContextRef(rpcName.getLastComponent(), data, contextRef, codec);
    }

    public Map<QName, String> getAttributes() {
        return this.delegate().getAttributes();
    }

    private ContainerNode delegate() {
        if (this.domData == null) {
            this.domData = this.registry.toNormalizedNodeRpcData((DataContainer)this.bindingData);
            this.registry = null;
        }
        return this.domData;
    }

    public final QName getNodeType() {
        return this.identifier.getNodeType();
    }

    public final Collection<DataContainerChild<? extends YangInstanceIdentifier.PathArgument, ?>> getValue() {
        return this.delegate().getValue();
    }

    public final YangInstanceIdentifier.NodeIdentifier getIdentifier() {
        return this.identifier;
    }

    public Optional<DataContainerChild<? extends YangInstanceIdentifier.PathArgument, ?>> getChild(YangInstanceIdentifier.PathArgument child) {
        return this.delegate().getChild(child);
    }

    public final Object getAttributeValue(QName name) {
        return this.delegate().getAttributeValue(name);
    }

    public final DataObject bindingData() {
        return this.bindingData;
    }

    private static final class WithContextRef
    extends LazySerializedContainerNode {
        private final LeafNode<?> contextRef;

        protected WithContextRef(QName identifier, DataObject binding, LeafNode<?> contextRef, BindingNormalizedNodeSerializer registry) {
            super(identifier, binding, registry);
            this.contextRef = contextRef;
        }

        @Override
        public Optional<DataContainerChild<? extends YangInstanceIdentifier.PathArgument, ?>> getChild(YangInstanceIdentifier.PathArgument child) {
            if (((YangInstanceIdentifier.NodeIdentifier)this.contextRef.getIdentifier()).equals((Object)child)) {
                return Optional.of(this.contextRef);
            }
            return super.getChild(child);
        }
    }
}

