/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.md.sal.binding.compat;

import com.google.common.collect.ImmutableSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.opendaylight.controller.md.sal.binding.impl.BindingDOMRpcProviderServiceAdapter;
import org.opendaylight.controller.sal.binding.api.BindingAwareBroker;
import org.opendaylight.yangtools.concepts.ObjectRegistration;
import org.opendaylight.yangtools.yang.binding.BaseIdentity;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;
import org.opendaylight.yangtools.yang.binding.RpcService;

final class CompositeRoutedRpcRegistration<T extends RpcService>
implements BindingAwareBroker.RoutedRpcRegistration<T> {
    private final Class<T> type;
    private final T instance;
    private final BindingDOMRpcProviderServiceAdapter adapter;
    private final Map<InstanceIdentifier<?>, ObjectRegistration<T>> registrations = new HashMap(2);

    CompositeRoutedRpcRegistration(Class<T> type, T impl, BindingDOMRpcProviderServiceAdapter providerAdapter) {
        this.type = type;
        this.instance = impl;
        this.adapter = providerAdapter;
    }

    public Class<T> getServiceType() {
        return this.type;
    }

    public T getInstance() {
        return this.instance;
    }

    @Deprecated
    public void registerInstance(Class<? extends BaseIdentity> context, InstanceIdentifier<?> path) {
        this.registerPath(context, path);
    }

    public synchronized void registerPath(Class<? extends BaseIdentity> context, InstanceIdentifier<?> path) {
        if (!this.registrations.containsKey(path)) {
            this.registrations.put(path, this.adapter.registerRpcImplementation(this.type, this.instance, (Set<InstanceIdentifier<?>>)ImmutableSet.of(path)));
        }
    }

    @Deprecated
    public void unregisterInstance(Class<? extends BaseIdentity> context, InstanceIdentifier<?> path) {
        this.unregisterPath(context, path);
    }

    public synchronized void unregisterPath(Class<? extends BaseIdentity> context, InstanceIdentifier<?> path) {
        ObjectRegistration<T> reg = this.registrations.remove(path);
        if (reg != null) {
            reg.close();
        }
    }

    public synchronized void close() {
        for (ObjectRegistration<T> reg : this.registrations.values()) {
            reg.close();
        }
    }
}

