/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.md.sal.binding.impl;

import com.google.common.collect.ImmutableMap;
import com.google.common.reflect.TypeToken;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.opendaylight.controller.md.sal.binding.impl.LazySerializedDOMNotification;
import org.opendaylight.controller.md.sal.dom.api.DOMNotification;
import org.opendaylight.controller.md.sal.dom.api.DOMNotificationListener;
import org.opendaylight.mdsal.binding.dom.adapter.invoke.NotificationListenerInvoker;
import org.opendaylight.mdsal.binding.dom.codec.api.BindingNormalizedNodeSerializer;
import org.opendaylight.mdsal.binding.spec.reflect.BindingReflections;
import org.opendaylight.yangtools.yang.binding.DataContainer;
import org.opendaylight.yangtools.yang.binding.Notification;
import org.opendaylight.yangtools.yang.binding.NotificationListener;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.model.api.SchemaPath;

class BindingDOMNotificationListenerAdapter
implements DOMNotificationListener {
    private final BindingNormalizedNodeSerializer codec;
    private final NotificationListener delegate;
    private final Map<SchemaPath, NotificationListenerInvoker> invokers;

    BindingDOMNotificationListenerAdapter(BindingNormalizedNodeSerializer codec, NotificationListener delegate) {
        this.codec = codec;
        this.delegate = delegate;
        this.invokers = BindingDOMNotificationListenerAdapter.createInvokerMapFor(delegate.getClass());
    }

    public void onNotification(DOMNotification notification) {
        Notification baNotification = this.deserialize(notification);
        QName notificationQName = notification.getType().getLastComponent();
        this.getInvoker(notification.getType()).invokeNotification(this.delegate, notificationQName, (DataContainer)baNotification);
    }

    private Notification deserialize(DOMNotification notification) {
        if (notification instanceof LazySerializedDOMNotification) {
            return ((LazySerializedDOMNotification)notification).getBindingData();
        }
        return this.codec.fromNormalizedNodeNotification(notification.getType(), notification.getBody());
    }

    private NotificationListenerInvoker getInvoker(SchemaPath type) {
        return this.invokers.get(type);
    }

    protected Set<SchemaPath> getSupportedNotifications() {
        return this.invokers.keySet();
    }

    public static Map<SchemaPath, NotificationListenerInvoker> createInvokerMapFor(Class<? extends NotificationListener> implClz) {
        HashMap<SchemaPath, NotificationListenerInvoker> builder = new HashMap<SchemaPath, NotificationListenerInvoker>();
        for (TypeToken ifaceToken : TypeToken.of(implClz).getTypes().interfaces()) {
            Class iface = ifaceToken.getRawType();
            if (!NotificationListener.class.isAssignableFrom(iface) || !BindingReflections.isBindingClass((Class)iface)) continue;
            Class listenerType = iface;
            NotificationListenerInvoker invoker = NotificationListenerInvoker.from((Class)listenerType);
            for (SchemaPath path : BindingDOMNotificationListenerAdapter.getNotificationTypes(listenerType)) {
                builder.put(path, invoker);
            }
        }
        return ImmutableMap.copyOf(builder);
    }

    private static Set<SchemaPath> getNotificationTypes(Class<? extends NotificationListener> type) {
        HashSet<SchemaPath> ret = new HashSet<SchemaPath>();
        for (Method method : type.getMethods()) {
            if (!BindingReflections.isNotificationCallback((Method)method)) continue;
            Class<?> notification = method.getParameterTypes()[0];
            QName name = BindingReflections.findQName(notification);
            ret.add(SchemaPath.create((boolean)true, (QName[])new QName[]{name}));
        }
        return ret;
    }
}

