/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.md.sal.binding.impl;

import com.google.common.collect.ClassToInstanceMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.opendaylight.controller.md.sal.binding.api.NotificationPublishService;
import org.opendaylight.controller.md.sal.binding.impl.BindingDOMAdapterBuilder;
import org.opendaylight.controller.md.sal.binding.impl.BindingToNormalizedNodeCodec;
import org.opendaylight.controller.md.sal.binding.impl.LazySerializedDOMNotification;
import org.opendaylight.controller.md.sal.dom.api.DOMNotification;
import org.opendaylight.controller.md.sal.dom.api.DOMNotificationPublishService;
import org.opendaylight.controller.md.sal.dom.api.DOMService;
import org.opendaylight.mdsal.binding.dom.codec.api.BindingNormalizedNodeSerializer;
import org.opendaylight.yangtools.yang.binding.Notification;

public class BindingDOMNotificationPublishServiceAdapter
implements NotificationPublishService,
AutoCloseable {
    static final BindingDOMAdapterBuilder.Factory<NotificationPublishService> BUILDER_FACTORY = Builder::new;
    private final BindingToNormalizedNodeCodec codecRegistry;
    private final DOMNotificationPublishService domPublishService;

    public BindingDOMNotificationPublishServiceAdapter(BindingToNormalizedNodeCodec codec, DOMNotificationPublishService domPublishService) {
        this.codecRegistry = codec;
        this.domPublishService = domPublishService;
    }

    public BindingToNormalizedNodeCodec getCodecRegistry() {
        return this.codecRegistry;
    }

    public DOMNotificationPublishService getDomPublishService() {
        return this.domPublishService;
    }

    public void putNotification(Notification notification) throws InterruptedException {
        this.domPublishService.putNotification(this.toDomNotification(notification));
    }

    public ListenableFuture<?> offerNotification(Notification notification) {
        ListenableFuture offerResult = this.domPublishService.offerNotification(this.toDomNotification(notification));
        return DOMNotificationPublishService.REJECTED.equals(offerResult) ? NotificationPublishService.REJECTED : offerResult;
    }

    public ListenableFuture<?> offerNotification(Notification notification, int timeout, TimeUnit unit) throws InterruptedException {
        ListenableFuture offerResult = this.domPublishService.offerNotification(this.toDomNotification(notification), (long)timeout, unit);
        return DOMNotificationPublishService.REJECTED.equals(offerResult) ? NotificationPublishService.REJECTED : offerResult;
    }

    private DOMNotification toDomNotification(Notification notification) {
        return LazySerializedDOMNotification.create((BindingNormalizedNodeSerializer)this.codecRegistry, notification);
    }

    @Override
    public void close() {
    }

    protected static class Builder
    extends BindingDOMAdapterBuilder<NotificationPublishService> {
        protected Builder() {
        }

        @Override
        public Set<Class<? extends DOMService>> getRequiredDelegates() {
            return ImmutableSet.of(DOMNotificationPublishService.class);
        }

        @Override
        protected NotificationPublishService createInstance(BindingToNormalizedNodeCodec codec, ClassToInstanceMap<DOMService> delegates) {
            DOMNotificationPublishService domPublish = (DOMNotificationPublishService)delegates.getInstance(DOMNotificationPublishService.class);
            return new BindingDOMNotificationPublishServiceAdapter(codec, domPublish);
        }
    }
}

