/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.md.sal.binding.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.opendaylight.controller.md.sal.binding.api.DataObjectModification;
import org.opendaylight.controller.md.sal.binding.api.DataTreeIdentifier;
import org.opendaylight.controller.md.sal.binding.api.DataTreeModification;
import org.opendaylight.controller.md.sal.binding.impl.BindingToNormalizedNodeCodec;
import org.opendaylight.controller.md.sal.binding.impl.LazyDataObjectModification;
import org.opendaylight.controller.md.sal.common.api.data.LogicalDatastoreType;
import org.opendaylight.mdsal.binding.dom.codec.api.BindingCodecTreeNode;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.tree.DataTreeCandidate;

class LazyDataTreeModification<T extends DataObject>
implements DataTreeModification<T> {
    private final DataTreeIdentifier<T> path;
    private final DataObjectModification<T> rootNode;

    LazyDataTreeModification(LogicalDatastoreType datastoreType, InstanceIdentifier<T> path, BindingCodecTreeNode<T> codec, DataTreeCandidate domChange) {
        this.path = new DataTreeIdentifier(datastoreType, path);
        this.rootNode = LazyDataObjectModification.create(codec, domChange.getRootNode());
    }

    public DataObjectModification<T> getRootNode() {
        return this.rootNode;
    }

    public DataTreeIdentifier<T> getRootPath() {
        return this.path;
    }

    static <T extends DataObject> DataTreeModification<T> create(BindingToNormalizedNodeCodec codec, DataTreeCandidate domChange, LogicalDatastoreType datastoreType) {
        Map.Entry<InstanceIdentifier<?>, BindingCodecTreeNode<?>> codecCtx = codec.getSubtreeCodec(domChange.getRootPath());
        return new LazyDataTreeModification(datastoreType, codecCtx.getKey(), codecCtx.getValue(), domChange);
    }

    static <T extends DataObject> Collection<DataTreeModification<T>> from(BindingToNormalizedNodeCodec codec, Collection<DataTreeCandidate> domChanges, LogicalDatastoreType datastoreType) {
        ArrayList<DataTreeModification<T>> result = new ArrayList<DataTreeModification<T>>(domChanges.size());
        for (DataTreeCandidate domChange : domChanges) {
            result.add(LazyDataTreeModification.create(codec, domChange, datastoreType));
        }
        return result;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{path = " + this.path + ", rootNode = " + this.rootNode + "}";
    }
}

