/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.md.sal.binding.util;

import com.google.common.base.Preconditions;
import org.opendaylight.controller.sal.binding.api.NotificationListener;
import org.opendaylight.controller.sal.binding.api.NotificationService;
import org.opendaylight.controller.sal.binding.api.RpcConsumerRegistry;
import org.opendaylight.yangtools.concepts.ListenerRegistration;
import org.opendaylight.yangtools.yang.binding.Notification;
import org.opendaylight.yangtools.yang.binding.RpcService;

public abstract class AbstractBindingSalConsumerInstance<N extends NotificationService, R extends RpcConsumerRegistry>
implements RpcConsumerRegistry,
NotificationService {
    private final R rpcRegistry;
    private final N notificationBroker;

    protected final R getRpcRegistry() {
        return this.rpcRegistry;
    }

    protected final N getNotificationBroker() {
        return this.notificationBroker;
    }

    protected final R getRpcRegistryChecked() {
        Preconditions.checkState((this.rpcRegistry != null ? 1 : 0) != 0, (Object)"Rpc Registry is not available.");
        return this.rpcRegistry;
    }

    protected final N getNotificationBrokerChecked() {
        Preconditions.checkState((this.notificationBroker != null ? 1 : 0) != 0, (Object)"Notification Broker is not available.");
        return this.notificationBroker;
    }

    protected AbstractBindingSalConsumerInstance(R rpcRegistry, N notificationBroker) {
        this.rpcRegistry = rpcRegistry;
        this.notificationBroker = notificationBroker;
    }

    public <T extends RpcService> T getRpcService(Class<T> module) {
        return (T)this.getRpcRegistryChecked().getRpcService(module);
    }

    public <T extends Notification> ListenerRegistration<NotificationListener<T>> registerNotificationListener(Class<T> notificationType, NotificationListener<T> listener) {
        return this.getNotificationBrokerChecked().registerNotificationListener(notificationType, listener);
    }

    public ListenerRegistration<org.opendaylight.yangtools.yang.binding.NotificationListener> registerNotificationListener(org.opendaylight.yangtools.yang.binding.NotificationListener listener) {
        return this.getNotificationBrokerChecked().registerNotificationListener(listener);
    }
}

