package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.cluster.admin.rev151013;
import java.lang.Class;
import java.lang.Override;
import java.lang.String;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.RpcInput;
import org.opendaylight.yangtools.yang.common.QName;

/**
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>cluster-admin</b>
 * <pre>
 * input {
 *   leaf shard-name {
 *     type string;
 *   }
 *   leaf data-store-type {
 *     type data-store-type;
 *   }
 * }
 * </pre>The schema path to identify an instance is
 * <i>cluster-admin/add-shard-replica/input</i>
 *
 * <p>To create instances of this class use {@link AddShardReplicaInputBuilder}.
 * @see AddShardReplicaInputBuilder
 *
 */
public interface AddShardReplicaInput
    extends
    RpcInput,
    Augmentable<AddShardReplicaInput>
{



    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("input");

    @Override
    default Class<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.cluster.admin.rev151013.AddShardReplicaInput> implementedInterface() {
        return org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.cluster.admin.rev151013.AddShardReplicaInput.class;
    }
    
    /**
     * The name of the shard for which to create a replica.
     *
     *
     *
     * @return <code>java.lang.String</code> <code>shardName</code>, or <code>null</code> if not present
     */
    @Nullable String getShardName();
    
    /**
     * The type of the data store to which the replica belongs
     *
     *
     *
     * @return <code>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.cluster.admin.rev151013.DataStoreType</code> <code>dataStoreType</code>, or <code>null</code> if not present
     */
    @Nullable DataStoreType getDataStoreType();

}

