package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.cluster.admin.rev151013;
import java.lang.Class;
import java.lang.Override;
import java.lang.String;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.RpcInput;
import org.opendaylight.yangtools.yang.common.QName;

/**
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>cluster-admin</b>
 * <pre>
 * input {
 *   leaf file-path {
 *     type string;
 *   }
 * }
 * </pre>The schema path to identify an instance is
 * <i>cluster-admin/backup-datastore/input</i>
 *
 * <p>To create instances of this class use {@link BackupDatastoreInputBuilder}.
 * @see BackupDatastoreInputBuilder
 *
 */
public interface BackupDatastoreInput
    extends
    RpcInput,
    Augmentable<BackupDatastoreInput>
{



    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("input");

    @Override
    default Class<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.cluster.admin.rev151013.BackupDatastoreInput> implementedInterface() {
        return org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.cluster.admin.rev151013.BackupDatastoreInput.class;
    }
    
    /**
     * The path and name of the file in which to store the backup.
     *
     *
     *
     * @return <code>java.lang.String</code> <code>filePath</code>, or <code>null</code> if not present
     */
    @Nullable String getFilePath();

}

