package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.cluster.admin.rev151013;
import java.lang.Class;
import java.lang.Override;
import java.lang.String;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.RpcInput;
import org.opendaylight.yangtools.yang.common.QName;

/**
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>cluster-admin</b>
 * <pre>
 * input {
 *   leaf shard-name {
 *     type string;
 *   }
 *   leaf data-store-type {
 *     type data-store-type;
 *   }
 *   uses member-voting-states-input;
 * }
 * </pre>The schema path to identify an instance is
 * <i>cluster-admin/change-member-voting-states-for-shard/input</i>
 *
 * <p>To create instances of this class use {@link ChangeMemberVotingStatesForShardInputBuilder}.
 * @see ChangeMemberVotingStatesForShardInputBuilder
 *
 */
public interface ChangeMemberVotingStatesForShardInput
    extends
    MemberVotingStatesInput,
    RpcInput,
    Augmentable<ChangeMemberVotingStatesForShardInput>
{



    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("input");

    @Override
    default Class<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.cluster.admin.rev151013.ChangeMemberVotingStatesForShardInput> implementedInterface() {
        return org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.cluster.admin.rev151013.ChangeMemberVotingStatesForShardInput.class;
    }
    
    /**
     * The name of the shard for which to change voting state.
     *
     *
     *
     * @return <code>java.lang.String</code> <code>shardName</code>, or <code>null</code> if not present
     */
    @Nullable String getShardName();
    
    /**
     * The type of the data store to which the shard belongs
     *
     *
     *
     * @return <code>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.cluster.admin.rev151013.DataStoreType</code> <code>dataStoreType</code>, or <code>null</code> if not present
     */
    @Nullable DataStoreType getDataStoreType();

}

