package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.cluster.admin.rev151013;
import com.google.common.util.concurrent.ListenableFuture;
import edu.umd.cs.findbugs.annotations.CheckReturnValue;
import org.opendaylight.yangtools.yang.binding.RpcService;
import org.opendaylight.yangtools.yang.common.RpcResult;

/**
 * Interface for implementing the following YANG RPCs defined in module <b>cluster-admin</b>
 * <pre>
 * rpc make-leader-local {
 *   input {
 *     leaf shard-name {
 *       type string;
 *     }
 *     leaf data-store-type {
 *       type data-store-type;
 *     }
 *   }
 *   output;
 * }
 * rpc remove-shard-replica {
 *   input {
 *     leaf shard-name {
 *       type string;
 *     }
 *     leaf member-name {
 *       type string;
 *     }
 *     leaf data-store-type {
 *       type data-store-type;
 *     }
 *   }
 *   output;
 * }
 * rpc change-member-voting-states-for-shard {
 *   input {
 *     leaf shard-name {
 *       type string;
 *     }
 *     leaf data-store-type {
 *       type data-store-type;
 *     }
 *     uses member-voting-states-input;
 *   }
 *   output;
 * }
 * rpc get-shard-role {
 *   input {
 *     leaf shard-name {
 *       type string;
 *     }
 *     leaf data-store-type {
 *       type data-store-type;
 *     }
 *   }
 *   output {
 *     leaf role {
 *       type string;
 *     }
 *   }
 * }
 * rpc add-prefix-shard-replica {
 *   input {
 *     leaf shard-prefix {
 *       type instance-identifier;
 *     }
 *     leaf data-store-type {
 *       type data-store-type;
 *     }
 *   }
 *   output;
 * }
 * rpc change-member-voting-states-for-all-shards {
 *   input {
 *     uses member-voting-states-input;
 *   }
 *   output {
 *     uses shard-result-output;
 *   }
 * }
 * rpc flip-member-voting-states-for-all-shards {
 *   output {
 *     uses shard-result-output;
 *   }
 *   input;
 * }
 * rpc add-replicas-for-all-shards {
 *   output {
 *     uses shard-result-output;
 *   }
 *   input;
 * }
 * rpc get-prefix-shard-role {
 *   input {
 *     leaf shard-prefix {
 *       type instance-identifier;
 *     }
 *     leaf data-store-type {
 *       type data-store-type;
 *     }
 *   }
 *   output {
 *     leaf role {
 *       type string;
 *     }
 *   }
 * }
 * rpc remove-all-shard-replicas {
 *   input {
 *     leaf member-name {
 *       type string;
 *     }
 *   }
 *   output {
 *     uses shard-result-output;
 *   }
 * }
 * rpc backup-datastore {
 *   input {
 *     leaf file-path {
 *       type string;
 *     }
 *   }
 *   output;
 * }
 * rpc remove-prefix-shard-replica {
 *   input {
 *     leaf shard-prefix {
 *       type instance-identifier;
 *     }
 *     leaf member-name {
 *       type string;
 *     }
 *     leaf data-store-type {
 *       type data-store-type;
 *     }
 *   }
 *   output;
 * }
 * rpc add-shard-replica {
 *   input {
 *     leaf shard-name {
 *       type string;
 *     }
 *     leaf data-store-type {
 *       type data-store-type;
 *     }
 *   }
 *   output;
 * }
 * </pre>
 *
 */
public interface ClusterAdminService
    extends
    RpcService
{




    /**
     * Attempts to move the shard leader of the given module based shard to the local 
     * node. The rpc returns a response after handling of the underlying 
     * MakeLeaderLocal message completes. This operation fails if there is no current 
     * shard leader due to lack of network connectivity or a cluster majority. In 
     * addition, if the local node is not up to date with the current leader, an 
     * attempt is made to first sync the local node with the leader. If this cannot be 
     * achieved within two election timeout periods the operation fails.
     *
     */
    @CheckReturnValue
    ListenableFuture<RpcResult<MakeLeaderLocalOutput>> makeLeaderLocal(MakeLeaderLocalInput input);
    
    /**
     * Removes an existing replica of a shard from this node via the RemoveServer 
     * mechanism as described in the Raft paper.
     *
     */
    @CheckReturnValue
    ListenableFuture<RpcResult<RemoveShardReplicaOutput>> removeShardReplica(RemoveShardReplicaInput input);
    
    /**
     * Changes the voting states, either voting or non-voting, of cluster members for a
     * shard. Non-voting members will no longer participate in leader elections and 
     * consensus but will be replicated. This is useful for having a set of members 
     * serve as a backup cluster in case the primary voting cluster suffers 
     * catastrophic failure. This RPC can be issued to any cluster member and will be 
     * forwarded to the leader.
     *
     */
    @CheckReturnValue
    ListenableFuture<RpcResult<ChangeMemberVotingStatesForShardOutput>> changeMemberVotingStatesForShard(ChangeMemberVotingStatesForShardInput input);
    
    /**
     * Returns the current role for the requested module shard.
     *
     */
    @CheckReturnValue
    ListenableFuture<RpcResult<GetShardRoleOutput>> getShardRole(GetShardRoleInput input);
    
    /**
     * Adds a replica of a shard to this node and joins it to an existing cluster. 
     * There must already be a shard existing on another node with a leader. This RPC 
     * first contacts peer member seed nodes searching for a shard. When found, an 
     * AddServer message is sent to the shard leader and applied as described in the 
     * Raft paper.
     *
     */
    @CheckReturnValue
    ListenableFuture<RpcResult<AddPrefixShardReplicaOutput>> addPrefixShardReplica(AddPrefixShardReplicaInput input);
    
    /**
     * Changes the voting states, either voting or non-voting, of cluster members for 
     * all shards. Non-voting members will no longer participate in leader elections 
     * and consensus but will be replicated. This is useful for having a set of members
     * serve as a backup cluster in case the primary voting cluster suffers 
     * catastrophic failure. This RPC can be issued to any cluster member and will be 
     * forwarded to the leader.
     *
     */
    @CheckReturnValue
    ListenableFuture<RpcResult<ChangeMemberVotingStatesForAllShardsOutput>> changeMemberVotingStatesForAllShards(ChangeMemberVotingStatesForAllShardsInput input);
    
    /**
     * Flips the voting states of all cluster members for all shards, such that if a 
     * member was voting it becomes non-voting and vice versa.
     *
     */
    @CheckReturnValue
    ListenableFuture<RpcResult<FlipMemberVotingStatesForAllShardsOutput>> flipMemberVotingStatesForAllShards(FlipMemberVotingStatesForAllShardsInput input);
    
    /**
     * Adds replicas on this node for all currently defined shards. This is equivalent 
     * to issuing an add-shard-replica RPC for all shards.
     *
     */
    @CheckReturnValue
    ListenableFuture<RpcResult<AddReplicasForAllShardsOutput>> addReplicasForAllShards(AddReplicasForAllShardsInput input);
    
    /**
     * Returns the current role for the requested module shard.
     *
     */
    @CheckReturnValue
    ListenableFuture<RpcResult<GetPrefixShardRoleOutput>> getPrefixShardRole(GetPrefixShardRoleInput input);
    
    /**
     * Removes replicas for all shards on this node. This is equivalent to issuing a 
     * remove-shard-replica for all shards and essentially removes this node from a 
     * cluster.
     *
     */
    @CheckReturnValue
    ListenableFuture<RpcResult<RemoveAllShardReplicasOutput>> removeAllShardReplicas(RemoveAllShardReplicasInput input);
    
    /**
     * Creates a backup file of the datastore state
     *
     */
    @CheckReturnValue
    ListenableFuture<RpcResult<BackupDatastoreOutput>> backupDatastore(BackupDatastoreInput input);
    
    /**
     * Removes an existing replica of a prefix shard from this node via the 
     * RemoveServer mechanism as described in the Raft paper.
     *
     */
    @CheckReturnValue
    ListenableFuture<RpcResult<RemovePrefixShardReplicaOutput>> removePrefixShardReplica(RemovePrefixShardReplicaInput input);
    
    /**
     * Adds a replica of a shard to this node and joins it to an existing cluster. The 
     * shard must already have a module configuration defined for it and there must 
     * already be a shard existing on another node with a leader. This RPC first 
     * contacts peer member seed nodes searching for a shard. When found, an AddServer 
     * message is sent to the shard leader and applied as described in the Raft paper.
     *
     */
    @CheckReturnValue
    ListenableFuture<RpcResult<AddShardReplicaOutput>> addShardReplica(AddShardReplicaInput input);

}

