package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.cluster.admin.rev151013;
import com.google.common.base.MoreObjects;
import java.lang.Class;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.cluster.admin.rev151013.shard.result.output.ShardResult;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link FlipMemberVotingStatesForAllShardsOutputBuilder} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     FlipMemberVotingStatesForAllShardsOutputBuilder createTarget(int fooXyzzy, int barBaz) {
 *         return new FlipMemberVotingStatesForAllShardsOutputBuilderBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of FlipMemberVotingStatesForAllShardsOutputBuilder, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization oportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see FlipMemberVotingStatesForAllShardsOutputBuilder
 * @see Builder
 *
 */
public class FlipMemberVotingStatesForAllShardsOutputBuilder implements Builder<FlipMemberVotingStatesForAllShardsOutput> {

    private List<ShardResult> _shardResult;


    Map<Class<? extends Augmentation<FlipMemberVotingStatesForAllShardsOutput>>, Augmentation<FlipMemberVotingStatesForAllShardsOutput>> augmentation = Collections.emptyMap();

    public FlipMemberVotingStatesForAllShardsOutputBuilder() {
    }
    public FlipMemberVotingStatesForAllShardsOutputBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.cluster.admin.rev151013.ShardResultOutput arg) {
        this._shardResult = arg.getShardResult();
    }

    public FlipMemberVotingStatesForAllShardsOutputBuilder(FlipMemberVotingStatesForAllShardsOutput base) {
        if (base instanceof AugmentationHolder) {
            @SuppressWarnings("unchecked")
            Map<Class<? extends Augmentation<FlipMemberVotingStatesForAllShardsOutput>>, Augmentation<FlipMemberVotingStatesForAllShardsOutput>> aug =((AugmentationHolder<FlipMemberVotingStatesForAllShardsOutput>) base).augmentations();
            if (!aug.isEmpty()) {
                this.augmentation = new HashMap<>(aug);
            }
        }
        this._shardResult = base.getShardResult();
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.cluster.admin.rev151013.ShardResultOutput</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.cluster.admin.rev151013.ShardResultOutput) {
            this._shardResult = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.cluster.admin.rev151013.ShardResultOutput)arg).getShardResult();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.cluster.admin.rev151013.ShardResultOutput]");
    }

    public List<ShardResult> getShardResult() {
        return _shardResult;
    }

    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<FlipMemberVotingStatesForAllShardsOutput>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
    }

    public FlipMemberVotingStatesForAllShardsOutputBuilder setShardResult(final List<ShardResult> values) {
        this._shardResult = values;
        return this;
    }
    
    
    public FlipMemberVotingStatesForAllShardsOutputBuilder addAugmentation(Class<? extends Augmentation<FlipMemberVotingStatesForAllShardsOutput>> augmentationType, Augmentation<FlipMemberVotingStatesForAllShardsOutput> augmentationValue) {
        if (augmentationValue == null) {
            return removeAugmentation(augmentationType);
        }
    
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }
    
    public FlipMemberVotingStatesForAllShardsOutputBuilder removeAugmentation(Class<? extends Augmentation<FlipMemberVotingStatesForAllShardsOutput>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public FlipMemberVotingStatesForAllShardsOutput build() {
        return new FlipMemberVotingStatesForAllShardsOutputImpl(this);
    }

    private static final class FlipMemberVotingStatesForAllShardsOutputImpl
        extends AbstractAugmentable<FlipMemberVotingStatesForAllShardsOutput>
        implements FlipMemberVotingStatesForAllShardsOutput {
    
        private final List<ShardResult> _shardResult;
    
        FlipMemberVotingStatesForAllShardsOutputImpl(FlipMemberVotingStatesForAllShardsOutputBuilder base) {
            super(base.augmentation);
            this._shardResult = base.getShardResult();
        }
    
        @Override
        public List<ShardResult> getShardResult() {
            return _shardResult;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int prime = 31;
            int result = 1;
            result = prime * result + Objects.hashCode(_shardResult);
            result = prime * result + Objects.hashCode(augmentations());
        
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!FlipMemberVotingStatesForAllShardsOutput.class.equals(((DataObject)obj).implementedInterface())) {
                return false;
            }
            FlipMemberVotingStatesForAllShardsOutput other = (FlipMemberVotingStatesForAllShardsOutput)obj;
            if (!Objects.equals(_shardResult, other.getShardResult())) {
                return false;
            }
            if (getClass() == obj.getClass()) {
                // Simple case: we are comparing against self
                FlipMemberVotingStatesForAllShardsOutputImpl otherImpl = (FlipMemberVotingStatesForAllShardsOutputImpl) obj;
                if (!Objects.equals(augmentations(), otherImpl.augmentations())) {
                    return false;
                }
            } else {
                // Hard case: compare our augments with presence there...
                for (Map.Entry<Class<? extends Augmentation<FlipMemberVotingStatesForAllShardsOutput>>, Augmentation<FlipMemberVotingStatesForAllShardsOutput>> e : augmentations().entrySet()) {
                    if (!e.getValue().equals(other.augmentation(e.getKey()))) {
                        return false;
                    }
                }
                // .. and give the other one the chance to do the same
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }
    
        @Override
        public String toString() {
            final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("FlipMemberVotingStatesForAllShardsOutput");
            CodeHelpers.appendValue(helper, "_shardResult", _shardResult);
            CodeHelpers.appendValue(helper, "augmentation", augmentations().values());
            return helper.toString();
        }
    }
}
