package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.cluster.admin.rev151013;
import com.google.common.base.MoreObjects;
import java.lang.Class;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;

/**
 * Class that builds {@link GetPrefixShardRoleInputBuilder} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     GetPrefixShardRoleInputBuilder createTarget(int fooXyzzy, int barBaz) {
 *         return new GetPrefixShardRoleInputBuilderBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of GetPrefixShardRoleInputBuilder, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization oportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see GetPrefixShardRoleInputBuilder
 * @see Builder
 *
 */
public class GetPrefixShardRoleInputBuilder implements Builder<GetPrefixShardRoleInput> {

    private DataStoreType _dataStoreType;
    private InstanceIdentifier<?> _shardPrefix;


    Map<Class<? extends Augmentation<GetPrefixShardRoleInput>>, Augmentation<GetPrefixShardRoleInput>> augmentation = Collections.emptyMap();

    public GetPrefixShardRoleInputBuilder() {
    }

    public GetPrefixShardRoleInputBuilder(GetPrefixShardRoleInput base) {
        if (base instanceof AugmentationHolder) {
            @SuppressWarnings("unchecked")
            Map<Class<? extends Augmentation<GetPrefixShardRoleInput>>, Augmentation<GetPrefixShardRoleInput>> aug =((AugmentationHolder<GetPrefixShardRoleInput>) base).augmentations();
            if (!aug.isEmpty()) {
                this.augmentation = new HashMap<>(aug);
            }
        }
        this._dataStoreType = base.getDataStoreType();
        this._shardPrefix = base.getShardPrefix();
    }


    public DataStoreType getDataStoreType() {
        return _dataStoreType;
    }
    
    public InstanceIdentifier<?> getShardPrefix() {
        return _shardPrefix;
    }

    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<GetPrefixShardRoleInput>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
    }

    
    public GetPrefixShardRoleInputBuilder setDataStoreType(final DataStoreType value) {
        this._dataStoreType = value;
        return this;
    }
    
    public GetPrefixShardRoleInputBuilder setShardPrefix(final InstanceIdentifier<?> value) {
        this._shardPrefix = value;
        return this;
    }
    
    public GetPrefixShardRoleInputBuilder addAugmentation(Class<? extends Augmentation<GetPrefixShardRoleInput>> augmentationType, Augmentation<GetPrefixShardRoleInput> augmentationValue) {
        if (augmentationValue == null) {
            return removeAugmentation(augmentationType);
        }
    
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }
    
    public GetPrefixShardRoleInputBuilder removeAugmentation(Class<? extends Augmentation<GetPrefixShardRoleInput>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public GetPrefixShardRoleInput build() {
        return new GetPrefixShardRoleInputImpl(this);
    }

    private static final class GetPrefixShardRoleInputImpl
        extends AbstractAugmentable<GetPrefixShardRoleInput>
        implements GetPrefixShardRoleInput {
    
        private final DataStoreType _dataStoreType;
        private final InstanceIdentifier<?> _shardPrefix;
    
        GetPrefixShardRoleInputImpl(GetPrefixShardRoleInputBuilder base) {
            super(base.augmentation);
            this._dataStoreType = base.getDataStoreType();
            this._shardPrefix = base.getShardPrefix();
        }
    
        @Override
        public DataStoreType getDataStoreType() {
            return _dataStoreType;
        }
        
        @Override
        public InstanceIdentifier<?> getShardPrefix() {
            return _shardPrefix;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int prime = 31;
            int result = 1;
            result = prime * result + Objects.hashCode(_dataStoreType);
            result = prime * result + Objects.hashCode(_shardPrefix);
            result = prime * result + Objects.hashCode(augmentations());
        
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!GetPrefixShardRoleInput.class.equals(((DataObject)obj).implementedInterface())) {
                return false;
            }
            GetPrefixShardRoleInput other = (GetPrefixShardRoleInput)obj;
            if (!Objects.equals(_dataStoreType, other.getDataStoreType())) {
                return false;
            }
            if (!Objects.equals(_shardPrefix, other.getShardPrefix())) {
                return false;
            }
            if (getClass() == obj.getClass()) {
                // Simple case: we are comparing against self
                GetPrefixShardRoleInputImpl otherImpl = (GetPrefixShardRoleInputImpl) obj;
                if (!Objects.equals(augmentations(), otherImpl.augmentations())) {
                    return false;
                }
            } else {
                // Hard case: compare our augments with presence there...
                for (Map.Entry<Class<? extends Augmentation<GetPrefixShardRoleInput>>, Augmentation<GetPrefixShardRoleInput>> e : augmentations().entrySet()) {
                    if (!e.getValue().equals(other.augmentation(e.getKey()))) {
                        return false;
                    }
                }
                // .. and give the other one the chance to do the same
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }
    
        @Override
        public String toString() {
            final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("GetPrefixShardRoleInput");
            CodeHelpers.appendValue(helper, "_dataStoreType", _dataStoreType);
            CodeHelpers.appendValue(helper, "_shardPrefix", _shardPrefix);
            CodeHelpers.appendValue(helper, "augmentation", augmentations().values());
            return helper.toString();
        }
    }
}
