package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.cluster.admin.rev151013;
import java.lang.Class;
import java.lang.Override;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.cluster.admin.rev151013.shard.result.output.ShardResult;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;

/**
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>cluster-admin</b>
 * <pre>
 * grouping shard-result-output {
 *   list shard-result {
 *     key "shard-name data-store-type";
 *     uses shard-operation-result;
 *   }
 * }
 * </pre>The schema path to identify an instance is
 * <i>cluster-admin/shard-result-output</i>
 *
 */
public interface ShardResultOutput
    extends
    DataObject
{



    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("shard-result-output");

    @Override
    Class<? extends ShardResultOutput> implementedInterface();
    
    /**
     * The list of results, one per shard
     *
     *
     *
     * @return <code>java.util.List</code> <code>shardResult</code>, or <code>null</code> if not present
     */
    @Nullable List<ShardResult> getShardResult();
    
    /**
     * @return <code>java.util.List</code> <code>shardResult</code>, or an empty list if it is not present
     */
    default @NonNull List<ShardResult> nonnullShardResult() {
        return CodeHelpers.nonnull(getShardResult());
    }

}

