package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.cluster.admin.rev151013.shard.result.output;
import com.google.common.base.MoreObjects;
import java.lang.Boolean;
import java.lang.Class;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.cluster.admin.rev151013.DataStoreType;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link ShardResultBuilder} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     ShardResultBuilder createTarget(int fooXyzzy, int barBaz) {
 *         return new ShardResultBuilderBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of ShardResultBuilder, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization oportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see ShardResultBuilder
 * @see Builder
 *
 */
public class ShardResultBuilder implements Builder<ShardResult> {

    private DataStoreType _dataStoreType;
    private String _errorMessage;
    private String _shardName;
    private Boolean _succeeded;
    private ShardResultKey key;


    Map<Class<? extends Augmentation<ShardResult>>, Augmentation<ShardResult>> augmentation = Collections.emptyMap();

    public ShardResultBuilder() {
    }
    public ShardResultBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.cluster.admin.rev151013.ShardOperationResult arg) {
        this._shardName = arg.getShardName();
        this._dataStoreType = arg.getDataStoreType();
        this._succeeded = arg.isSucceeded();
        this._errorMessage = arg.getErrorMessage();
    }

    public ShardResultBuilder(ShardResult base) {
        if (base instanceof AugmentationHolder) {
            @SuppressWarnings("unchecked")
            Map<Class<? extends Augmentation<ShardResult>>, Augmentation<ShardResult>> aug =((AugmentationHolder<ShardResult>) base).augmentations();
            if (!aug.isEmpty()) {
                this.augmentation = new HashMap<>(aug);
            }
        }
        this.key = base.key();
        this._dataStoreType = base.getDataStoreType();
        this._shardName = base.getShardName();
        this._errorMessage = base.getErrorMessage();
        this._succeeded = base.isSucceeded();
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.cluster.admin.rev151013.ShardOperationResult</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.cluster.admin.rev151013.ShardOperationResult) {
            this._shardName = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.cluster.admin.rev151013.ShardOperationResult)arg).getShardName();
            this._dataStoreType = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.cluster.admin.rev151013.ShardOperationResult)arg).getDataStoreType();
            this._succeeded = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.cluster.admin.rev151013.ShardOperationResult)arg).isSucceeded();
            this._errorMessage = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.cluster.admin.rev151013.ShardOperationResult)arg).getErrorMessage();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.cluster.admin.rev151013.ShardOperationResult]");
    }

    public ShardResultKey key() {
        return key;
    }
    
    public DataStoreType getDataStoreType() {
        return _dataStoreType;
    }
    
    public String getErrorMessage() {
        return _errorMessage;
    }
    
    public String getShardName() {
        return _shardName;
    }
    
    public Boolean isSucceeded() {
        return _succeeded;
    }

    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<ShardResult>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
    }

    public ShardResultBuilder withKey(final ShardResultKey key) {
        this.key = key;
        return this;
    }
    
    public ShardResultBuilder setDataStoreType(final DataStoreType value) {
        this._dataStoreType = value;
        return this;
    }
    
    public ShardResultBuilder setErrorMessage(final String value) {
        this._errorMessage = value;
        return this;
    }
    
    public ShardResultBuilder setShardName(final String value) {
        this._shardName = value;
        return this;
    }
    
    public ShardResultBuilder setSucceeded(final Boolean value) {
        this._succeeded = value;
        return this;
    }
    
    public ShardResultBuilder addAugmentation(Class<? extends Augmentation<ShardResult>> augmentationType, Augmentation<ShardResult> augmentationValue) {
        if (augmentationValue == null) {
            return removeAugmentation(augmentationType);
        }
    
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }
    
    public ShardResultBuilder removeAugmentation(Class<? extends Augmentation<ShardResult>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public ShardResult build() {
        return new ShardResultImpl(this);
    }

    private static final class ShardResultImpl
        extends AbstractAugmentable<ShardResult>
        implements ShardResult {
    
        private final DataStoreType _dataStoreType;
        private final String _errorMessage;
        private final String _shardName;
        private final Boolean _succeeded;
        private final ShardResultKey key;
    
        ShardResultImpl(ShardResultBuilder base) {
            super(base.augmentation);
            if (base.key() != null) {
                this.key = base.key();
            } else {
                this.key = new ShardResultKey(base.getDataStoreType(), base.getShardName());
            }
            this._dataStoreType = key.getDataStoreType();
            this._shardName = key.getShardName();
            this._errorMessage = base.getErrorMessage();
            this._succeeded = base.isSucceeded();
        }
    
        @Override
        public ShardResultKey key() {
            return key;
        }
        
        @Override
        public DataStoreType getDataStoreType() {
            return _dataStoreType;
        }
        
        @Override
        public String getErrorMessage() {
            return _errorMessage;
        }
        
        @Override
        public String getShardName() {
            return _shardName;
        }
        
        @Override
        public Boolean isSucceeded() {
            return _succeeded;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int prime = 31;
            int result = 1;
            result = prime * result + Objects.hashCode(_dataStoreType);
            result = prime * result + Objects.hashCode(_errorMessage);
            result = prime * result + Objects.hashCode(_shardName);
            result = prime * result + Objects.hashCode(_succeeded);
            result = prime * result + Objects.hashCode(augmentations());
        
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!ShardResult.class.equals(((DataObject)obj).implementedInterface())) {
                return false;
            }
            ShardResult other = (ShardResult)obj;
            if (!Objects.equals(_dataStoreType, other.getDataStoreType())) {
                return false;
            }
            if (!Objects.equals(_errorMessage, other.getErrorMessage())) {
                return false;
            }
            if (!Objects.equals(_shardName, other.getShardName())) {
                return false;
            }
            if (!Objects.equals(_succeeded, other.isSucceeded())) {
                return false;
            }
            if (getClass() == obj.getClass()) {
                // Simple case: we are comparing against self
                ShardResultImpl otherImpl = (ShardResultImpl) obj;
                if (!Objects.equals(augmentations(), otherImpl.augmentations())) {
                    return false;
                }
            } else {
                // Hard case: compare our augments with presence there...
                for (Map.Entry<Class<? extends Augmentation<ShardResult>>, Augmentation<ShardResult>> e : augmentations().entrySet()) {
                    if (!e.getValue().equals(other.augmentation(e.getKey()))) {
                        return false;
                    }
                }
                // .. and give the other one the chance to do the same
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }
    
        @Override
        public String toString() {
            final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("ShardResult");
            CodeHelpers.appendValue(helper, "_dataStoreType", _dataStoreType);
            CodeHelpers.appendValue(helper, "_errorMessage", _errorMessage);
            CodeHelpers.appendValue(helper, "_shardName", _shardName);
            CodeHelpers.appendValue(helper, "_succeeded", _succeeded);
            CodeHelpers.appendValue(helper, "augmentation", augmentations().values());
            return helper.toString();
        }
    }
}
