/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.cluster.admin.rev151013.shard.result.output;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.cluster.admin.rev151013.DataStoreType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.cluster.admin.rev151013.ShardOperationResult;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.cluster.admin.rev151013.shard.result.output.ShardResult;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.cluster.admin.rev151013.shard.result.output.ShardResultKey;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class ShardResultBuilder
implements Builder<ShardResult> {
    private DataStoreType _dataStoreType;
    private String _errorMessage;
    private String _shardName;
    private Boolean _succeeded;
    private ShardResultKey key;
    Map<Class<? extends Augmentation<ShardResult>>, Augmentation<ShardResult>> augmentation = Collections.emptyMap();

    public ShardResultBuilder() {
    }

    public ShardResultBuilder(ShardOperationResult arg) {
        this._shardName = arg.getShardName();
        this._dataStoreType = arg.getDataStoreType();
        this._succeeded = arg.isSucceeded();
        this._errorMessage = arg.getErrorMessage();
    }

    public ShardResultBuilder(ShardResult base) {
        Map aug;
        this.key = base.key();
        this._dataStoreType = base.getDataStoreType();
        this._shardName = base.getShardName();
        this._errorMessage = base.getErrorMessage();
        this._succeeded = base.isSucceeded();
        if (base instanceof ShardResultImpl) {
            ShardResultImpl impl = (ShardResultImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<ShardResult>>, Augmentation<ShardResult>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(aug = ((AugmentationHolder)base).augmentations()).isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<ShardResult>>, Augmentation<ShardResult>>(aug);
        }
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof ShardOperationResult) {
            this._shardName = ((ShardOperationResult)arg).getShardName();
            this._dataStoreType = ((ShardOperationResult)arg).getDataStoreType();
            this._succeeded = ((ShardOperationResult)arg).isSucceeded();
            this._errorMessage = ((ShardOperationResult)arg).getErrorMessage();
            isValidArg = true;
        }
        CodeHelpers.validValue((boolean)isValidArg, (Object)arg, (String)"[org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.cluster.admin.rev151013.ShardOperationResult]");
    }

    public ShardResultKey key() {
        return this.key;
    }

    public DataStoreType getDataStoreType() {
        return this._dataStoreType;
    }

    public String getErrorMessage() {
        return this._errorMessage;
    }

    public String getShardName() {
        return this._shardName;
    }

    public Boolean isSucceeded() {
        return this._succeeded;
    }

    public <E extends Augmentation<ShardResult>> E augmentation(Class<E> augmentationType) {
        return (E)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, (String)"augmentationType"));
    }

    public ShardResultBuilder withKey(ShardResultKey key) {
        this.key = key;
        return this;
    }

    public ShardResultBuilder setDataStoreType(DataStoreType value) {
        this._dataStoreType = value;
        return this;
    }

    public ShardResultBuilder setErrorMessage(String value) {
        this._errorMessage = value;
        return this;
    }

    public ShardResultBuilder setShardName(String value) {
        this._shardName = value;
        return this;
    }

    public ShardResultBuilder setSucceeded(Boolean value) {
        this._succeeded = value;
        return this;
    }

    public ShardResultBuilder addAugmentation(Class<? extends Augmentation<ShardResult>> augmentationType, Augmentation<ShardResult> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<ShardResult>>, Augmentation<ShardResult>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public ShardResultBuilder removeAugmentation(Class<? extends Augmentation<ShardResult>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public ShardResult build() {
        return new ShardResultImpl(this);
    }

    private static final class ShardResultImpl
    implements ShardResult {
        private final DataStoreType _dataStoreType;
        private final String _errorMessage;
        private final String _shardName;
        private final Boolean _succeeded;
        private final ShardResultKey key;
        private Map<Class<? extends Augmentation<ShardResult>>, Augmentation<ShardResult>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        ShardResultImpl(ShardResultBuilder base) {
            this.key = base.key() != null ? base.key() : new ShardResultKey(base.getDataStoreType(), base.getShardName());
            this._dataStoreType = this.key.getDataStoreType();
            this._shardName = this.key.getShardName();
            this._errorMessage = base.getErrorMessage();
            this._succeeded = base.isSucceeded();
            this.augmentation = ImmutableMap.copyOf(base.augmentation);
        }

        public Class<ShardResult> getImplementedInterface() {
            return ShardResult.class;
        }

        @Override
        public ShardResultKey key() {
            return this.key;
        }

        @Override
        public DataStoreType getDataStoreType() {
            return this._dataStoreType;
        }

        @Override
        public String getErrorMessage() {
            return this._errorMessage;
        }

        @Override
        public String getShardName() {
            return this._shardName;
        }

        @Override
        public Boolean isSucceeded() {
            return this._succeeded;
        }

        public <E extends Augmentation<ShardResult>> E augmentation(Class<E> augmentationType) {
            return (E)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, (String)"augmentationType"));
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode((Object)this._dataStoreType);
            result = 31 * result + Objects.hashCode(this._errorMessage);
            result = 31 * result + Objects.hashCode(this._shardName);
            result = 31 * result + Objects.hashCode(this._succeeded);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!ShardResult.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            ShardResult other = (ShardResult)obj;
            if (!Objects.equals((Object)this._dataStoreType, (Object)other.getDataStoreType())) {
                return false;
            }
            if (!Objects.equals(this._errorMessage, other.getErrorMessage())) {
                return false;
            }
            if (!Objects.equals(this._shardName, other.getShardName())) {
                return false;
            }
            if (!Objects.equals(this._succeeded, other.isSucceeded())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                ShardResultImpl otherImpl = (ShardResultImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<ShardResult>>, Augmentation<ShardResult>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.augmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper((String)"ShardResult");
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_dataStoreType", (Object)((Object)this._dataStoreType));
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_errorMessage", (Object)this._errorMessage);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_shardName", (Object)this._shardName);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_succeeded", (Object)this._succeeded);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"augmentation", this.augmentation.values());
            return helper.toString();
        }
    }
}

