package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.cluster.admin.rev151013;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.lang.Class;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link AddPrefixShardReplicaOutputBuilder} instances.
 *
 * @see AddPrefixShardReplicaOutputBuilder
 *
 */
public class AddPrefixShardReplicaOutputBuilder implements Builder<AddPrefixShardReplicaOutput> {



    Map<Class<? extends Augmentation<AddPrefixShardReplicaOutput>>, Augmentation<AddPrefixShardReplicaOutput>> augmentation = Collections.emptyMap();

    public AddPrefixShardReplicaOutputBuilder() {
    }

    public AddPrefixShardReplicaOutputBuilder(AddPrefixShardReplicaOutput base) {
        if (base instanceof AddPrefixShardReplicaOutputImpl) {
            AddPrefixShardReplicaOutputImpl impl = (AddPrefixShardReplicaOutputImpl) base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder) {
            @SuppressWarnings("unchecked")
            Map<Class<? extends Augmentation<AddPrefixShardReplicaOutput>>, Augmentation<AddPrefixShardReplicaOutput>> aug =((AugmentationHolder<AddPrefixShardReplicaOutput>) base).augmentations();
            if (!aug.isEmpty()) {
                this.augmentation = new HashMap<>(aug);
            }
        }
    }


    
    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<AddPrefixShardReplicaOutput>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
    }

    
    public AddPrefixShardReplicaOutputBuilder addAugmentation(Class<? extends Augmentation<AddPrefixShardReplicaOutput>> augmentationType, Augmentation<AddPrefixShardReplicaOutput> augmentationValue) {
        if (augmentationValue == null) {
            return removeAugmentation(augmentationType);
        }
    
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }
    
    public AddPrefixShardReplicaOutputBuilder removeAugmentation(Class<? extends Augmentation<AddPrefixShardReplicaOutput>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public AddPrefixShardReplicaOutput build() {
        return new AddPrefixShardReplicaOutputImpl(this);
    }

    private static final class AddPrefixShardReplicaOutputImpl implements AddPrefixShardReplicaOutput {
    
    
        private Map<Class<? extends Augmentation<AddPrefixShardReplicaOutput>>, Augmentation<AddPrefixShardReplicaOutput>> augmentation = Collections.emptyMap();
    
        AddPrefixShardReplicaOutputImpl(AddPrefixShardReplicaOutputBuilder base) {
            this.augmentation = ImmutableMap.copyOf(base.augmentation);
        }
    
        @Override
        public Class<AddPrefixShardReplicaOutput> getImplementedInterface() {
            return AddPrefixShardReplicaOutput.class;
        }
    
        
        @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
        @Override
        public <E$$ extends Augmentation<AddPrefixShardReplicaOutput>> E$$ augmentation(Class<E$$> augmentationType) {
            return (E$$) augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int prime = 31;
            int result = 1;
            result = prime * result + Objects.hashCode(augmentation);
        
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!AddPrefixShardReplicaOutput.class.equals(((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            AddPrefixShardReplicaOutput other = (AddPrefixShardReplicaOutput)obj;
            if (getClass() == obj.getClass()) {
                // Simple case: we are comparing against self
                AddPrefixShardReplicaOutputImpl otherImpl = (AddPrefixShardReplicaOutputImpl) obj;
                if (!Objects.equals(augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                // Hard case: compare our augments with presence there...
                for (Map.Entry<Class<? extends Augmentation<AddPrefixShardReplicaOutput>>, Augmentation<AddPrefixShardReplicaOutput>> e : augmentation.entrySet()) {
                    if (!e.getValue().equals(other.augmentation(e.getKey()))) {
                        return false;
                    }
                }
                // .. and give the other one the chance to do the same
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }
    
        @Override
        public String toString() {
            final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("AddPrefixShardReplicaOutput");
            CodeHelpers.appendValue(helper, "augmentation", augmentation.values());
            return helper.toString();
        }
    }
}
