package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.cluster.admin.rev151013;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.lang.Class;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.cluster.admin.rev151013.shard.result.output.ShardResult;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link AddReplicasForAllShardsOutputBuilder} instances.
 *
 * @see AddReplicasForAllShardsOutputBuilder
 *
 */
public class AddReplicasForAllShardsOutputBuilder implements Builder<AddReplicasForAllShardsOutput> {

    private List<ShardResult> _shardResult;


    Map<Class<? extends Augmentation<AddReplicasForAllShardsOutput>>, Augmentation<AddReplicasForAllShardsOutput>> augmentation = Collections.emptyMap();

    public AddReplicasForAllShardsOutputBuilder() {
    }
    public AddReplicasForAllShardsOutputBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.cluster.admin.rev151013.ShardResultOutput arg) {
        this._shardResult = arg.getShardResult();
    }

    public AddReplicasForAllShardsOutputBuilder(AddReplicasForAllShardsOutput base) {
        this._shardResult = base.getShardResult();
        if (base instanceof AddReplicasForAllShardsOutputImpl) {
            AddReplicasForAllShardsOutputImpl impl = (AddReplicasForAllShardsOutputImpl) base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder) {
            @SuppressWarnings("unchecked")
            Map<Class<? extends Augmentation<AddReplicasForAllShardsOutput>>, Augmentation<AddReplicasForAllShardsOutput>> aug =((AugmentationHolder<AddReplicasForAllShardsOutput>) base).augmentations();
            if (!aug.isEmpty()) {
                this.augmentation = new HashMap<>(aug);
            }
        }
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.cluster.admin.rev151013.ShardResultOutput</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.cluster.admin.rev151013.ShardResultOutput) {
            this._shardResult = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.cluster.admin.rev151013.ShardResultOutput)arg).getShardResult();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.cluster.admin.rev151013.ShardResultOutput]");
    }

    public List<ShardResult> getShardResult() {
        return _shardResult;
    }
    
    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<AddReplicasForAllShardsOutput>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
    }

    public AddReplicasForAllShardsOutputBuilder setShardResult(final List<ShardResult> values) {
        this._shardResult = values;
        return this;
    }
    
    
    public AddReplicasForAllShardsOutputBuilder addAugmentation(Class<? extends Augmentation<AddReplicasForAllShardsOutput>> augmentationType, Augmentation<AddReplicasForAllShardsOutput> augmentationValue) {
        if (augmentationValue == null) {
            return removeAugmentation(augmentationType);
        }
    
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }
    
    public AddReplicasForAllShardsOutputBuilder removeAugmentation(Class<? extends Augmentation<AddReplicasForAllShardsOutput>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public AddReplicasForAllShardsOutput build() {
        return new AddReplicasForAllShardsOutputImpl(this);
    }

    private static final class AddReplicasForAllShardsOutputImpl implements AddReplicasForAllShardsOutput {
    
        private final List<ShardResult> _shardResult;
    
        private Map<Class<? extends Augmentation<AddReplicasForAllShardsOutput>>, Augmentation<AddReplicasForAllShardsOutput>> augmentation = Collections.emptyMap();
    
        AddReplicasForAllShardsOutputImpl(AddReplicasForAllShardsOutputBuilder base) {
            this._shardResult = base.getShardResult();
            this.augmentation = ImmutableMap.copyOf(base.augmentation);
        }
    
        @Override
        public Class<AddReplicasForAllShardsOutput> getImplementedInterface() {
            return AddReplicasForAllShardsOutput.class;
        }
    
        @Override
        public List<ShardResult> getShardResult() {
            return _shardResult;
        }
        
        @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
        @Override
        public <E$$ extends Augmentation<AddReplicasForAllShardsOutput>> E$$ augmentation(Class<E$$> augmentationType) {
            return (E$$) augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int prime = 31;
            int result = 1;
            result = prime * result + Objects.hashCode(_shardResult);
            result = prime * result + Objects.hashCode(augmentation);
        
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!AddReplicasForAllShardsOutput.class.equals(((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            AddReplicasForAllShardsOutput other = (AddReplicasForAllShardsOutput)obj;
            if (!Objects.equals(_shardResult, other.getShardResult())) {
                return false;
            }
            if (getClass() == obj.getClass()) {
                // Simple case: we are comparing against self
                AddReplicasForAllShardsOutputImpl otherImpl = (AddReplicasForAllShardsOutputImpl) obj;
                if (!Objects.equals(augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                // Hard case: compare our augments with presence there...
                for (Map.Entry<Class<? extends Augmentation<AddReplicasForAllShardsOutput>>, Augmentation<AddReplicasForAllShardsOutput>> e : augmentation.entrySet()) {
                    if (!e.getValue().equals(other.augmentation(e.getKey()))) {
                        return false;
                    }
                }
                // .. and give the other one the chance to do the same
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }
    
        @Override
        public String toString() {
            final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("AddReplicasForAllShardsOutput");
            CodeHelpers.appendValue(helper, "_shardResult", _shardResult);
            CodeHelpers.appendValue(helper, "augmentation", augmentation.values());
            return helper.toString();
        }
    }
}
