package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.cluster.admin.rev151013;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.lang.Class;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link BackupDatastoreInputBuilder} instances.
 *
 * @see BackupDatastoreInputBuilder
 *
 */
public class BackupDatastoreInputBuilder implements Builder<BackupDatastoreInput> {

    private String _filePath;


    Map<Class<? extends Augmentation<BackupDatastoreInput>>, Augmentation<BackupDatastoreInput>> augmentation = Collections.emptyMap();

    public BackupDatastoreInputBuilder() {
    }

    public BackupDatastoreInputBuilder(BackupDatastoreInput base) {
        this._filePath = base.getFilePath();
        if (base instanceof BackupDatastoreInputImpl) {
            BackupDatastoreInputImpl impl = (BackupDatastoreInputImpl) base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder) {
            @SuppressWarnings("unchecked")
            Map<Class<? extends Augmentation<BackupDatastoreInput>>, Augmentation<BackupDatastoreInput>> aug =((AugmentationHolder<BackupDatastoreInput>) base).augmentations();
            if (!aug.isEmpty()) {
                this.augmentation = new HashMap<>(aug);
            }
        }
    }


    public String getFilePath() {
        return _filePath;
    }
    
    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<BackupDatastoreInput>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
    }

    
    public BackupDatastoreInputBuilder setFilePath(final String value) {
        this._filePath = value;
        return this;
    }
    
    public BackupDatastoreInputBuilder addAugmentation(Class<? extends Augmentation<BackupDatastoreInput>> augmentationType, Augmentation<BackupDatastoreInput> augmentationValue) {
        if (augmentationValue == null) {
            return removeAugmentation(augmentationType);
        }
    
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }
    
    public BackupDatastoreInputBuilder removeAugmentation(Class<? extends Augmentation<BackupDatastoreInput>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public BackupDatastoreInput build() {
        return new BackupDatastoreInputImpl(this);
    }

    private static final class BackupDatastoreInputImpl implements BackupDatastoreInput {
    
        private final String _filePath;
    
        private Map<Class<? extends Augmentation<BackupDatastoreInput>>, Augmentation<BackupDatastoreInput>> augmentation = Collections.emptyMap();
    
        BackupDatastoreInputImpl(BackupDatastoreInputBuilder base) {
            this._filePath = base.getFilePath();
            this.augmentation = ImmutableMap.copyOf(base.augmentation);
        }
    
        @Override
        public Class<BackupDatastoreInput> getImplementedInterface() {
            return BackupDatastoreInput.class;
        }
    
        @Override
        public String getFilePath() {
            return _filePath;
        }
        
        @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
        @Override
        public <E$$ extends Augmentation<BackupDatastoreInput>> E$$ augmentation(Class<E$$> augmentationType) {
            return (E$$) augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int prime = 31;
            int result = 1;
            result = prime * result + Objects.hashCode(_filePath);
            result = prime * result + Objects.hashCode(augmentation);
        
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!BackupDatastoreInput.class.equals(((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            BackupDatastoreInput other = (BackupDatastoreInput)obj;
            if (!Objects.equals(_filePath, other.getFilePath())) {
                return false;
            }
            if (getClass() == obj.getClass()) {
                // Simple case: we are comparing against self
                BackupDatastoreInputImpl otherImpl = (BackupDatastoreInputImpl) obj;
                if (!Objects.equals(augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                // Hard case: compare our augments with presence there...
                for (Map.Entry<Class<? extends Augmentation<BackupDatastoreInput>>, Augmentation<BackupDatastoreInput>> e : augmentation.entrySet()) {
                    if (!e.getValue().equals(other.augmentation(e.getKey()))) {
                        return false;
                    }
                }
                // .. and give the other one the chance to do the same
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }
    
        @Override
        public String toString() {
            final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("BackupDatastoreInput");
            CodeHelpers.appendValue(helper, "_filePath", _filePath);
            CodeHelpers.appendValue(helper, "augmentation", augmentation.values());
            return helper.toString();
        }
    }
}
