package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.cluster.admin.rev151013;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.lang.Class;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link BackupDatastoreOutputBuilder} instances.
 *
 * @see BackupDatastoreOutputBuilder
 *
 */
public class BackupDatastoreOutputBuilder implements Builder<BackupDatastoreOutput> {



    Map<Class<? extends Augmentation<BackupDatastoreOutput>>, Augmentation<BackupDatastoreOutput>> augmentation = Collections.emptyMap();

    public BackupDatastoreOutputBuilder() {
    }

    public BackupDatastoreOutputBuilder(BackupDatastoreOutput base) {
        if (base instanceof BackupDatastoreOutputImpl) {
            BackupDatastoreOutputImpl impl = (BackupDatastoreOutputImpl) base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder) {
            @SuppressWarnings("unchecked")
            Map<Class<? extends Augmentation<BackupDatastoreOutput>>, Augmentation<BackupDatastoreOutput>> aug =((AugmentationHolder<BackupDatastoreOutput>) base).augmentations();
            if (!aug.isEmpty()) {
                this.augmentation = new HashMap<>(aug);
            }
        }
    }


    
    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<BackupDatastoreOutput>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
    }

    
    public BackupDatastoreOutputBuilder addAugmentation(Class<? extends Augmentation<BackupDatastoreOutput>> augmentationType, Augmentation<BackupDatastoreOutput> augmentationValue) {
        if (augmentationValue == null) {
            return removeAugmentation(augmentationType);
        }
    
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }
    
    public BackupDatastoreOutputBuilder removeAugmentation(Class<? extends Augmentation<BackupDatastoreOutput>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public BackupDatastoreOutput build() {
        return new BackupDatastoreOutputImpl(this);
    }

    private static final class BackupDatastoreOutputImpl implements BackupDatastoreOutput {
    
    
        private Map<Class<? extends Augmentation<BackupDatastoreOutput>>, Augmentation<BackupDatastoreOutput>> augmentation = Collections.emptyMap();
    
        BackupDatastoreOutputImpl(BackupDatastoreOutputBuilder base) {
            this.augmentation = ImmutableMap.copyOf(base.augmentation);
        }
    
        @Override
        public Class<BackupDatastoreOutput> getImplementedInterface() {
            return BackupDatastoreOutput.class;
        }
    
        
        @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
        @Override
        public <E$$ extends Augmentation<BackupDatastoreOutput>> E$$ augmentation(Class<E$$> augmentationType) {
            return (E$$) augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int prime = 31;
            int result = 1;
            result = prime * result + Objects.hashCode(augmentation);
        
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!BackupDatastoreOutput.class.equals(((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            BackupDatastoreOutput other = (BackupDatastoreOutput)obj;
            if (getClass() == obj.getClass()) {
                // Simple case: we are comparing against self
                BackupDatastoreOutputImpl otherImpl = (BackupDatastoreOutputImpl) obj;
                if (!Objects.equals(augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                // Hard case: compare our augments with presence there...
                for (Map.Entry<Class<? extends Augmentation<BackupDatastoreOutput>>, Augmentation<BackupDatastoreOutput>> e : augmentation.entrySet()) {
                    if (!e.getValue().equals(other.augmentation(e.getKey()))) {
                        return false;
                    }
                }
                // .. and give the other one the chance to do the same
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }
    
        @Override
        public String toString() {
            final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("BackupDatastoreOutput");
            CodeHelpers.appendValue(helper, "augmentation", augmentation.values());
            return helper.toString();
        }
    }
}
