package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.cluster.admin.rev151013;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.lang.Class;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.cluster.admin.rev151013.member.voting.states.input.MemberVotingState;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link ChangeMemberVotingStatesForAllShardsInputBuilder} instances.
 *
 * @see ChangeMemberVotingStatesForAllShardsInputBuilder
 *
 */
public class ChangeMemberVotingStatesForAllShardsInputBuilder implements Builder<ChangeMemberVotingStatesForAllShardsInput> {

    private List<MemberVotingState> _memberVotingState;


    Map<Class<? extends Augmentation<ChangeMemberVotingStatesForAllShardsInput>>, Augmentation<ChangeMemberVotingStatesForAllShardsInput>> augmentation = Collections.emptyMap();

    public ChangeMemberVotingStatesForAllShardsInputBuilder() {
    }
    public ChangeMemberVotingStatesForAllShardsInputBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.cluster.admin.rev151013.MemberVotingStatesInput arg) {
        this._memberVotingState = arg.getMemberVotingState();
    }

    public ChangeMemberVotingStatesForAllShardsInputBuilder(ChangeMemberVotingStatesForAllShardsInput base) {
        this._memberVotingState = base.getMemberVotingState();
        if (base instanceof ChangeMemberVotingStatesForAllShardsInputImpl) {
            ChangeMemberVotingStatesForAllShardsInputImpl impl = (ChangeMemberVotingStatesForAllShardsInputImpl) base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder) {
            @SuppressWarnings("unchecked")
            Map<Class<? extends Augmentation<ChangeMemberVotingStatesForAllShardsInput>>, Augmentation<ChangeMemberVotingStatesForAllShardsInput>> aug =((AugmentationHolder<ChangeMemberVotingStatesForAllShardsInput>) base).augmentations();
            if (!aug.isEmpty()) {
                this.augmentation = new HashMap<>(aug);
            }
        }
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.cluster.admin.rev151013.MemberVotingStatesInput</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.cluster.admin.rev151013.MemberVotingStatesInput) {
            this._memberVotingState = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.cluster.admin.rev151013.MemberVotingStatesInput)arg).getMemberVotingState();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.cluster.admin.rev151013.MemberVotingStatesInput]");
    }

    public List<MemberVotingState> getMemberVotingState() {
        return _memberVotingState;
    }
    
    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<ChangeMemberVotingStatesForAllShardsInput>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
    }

    public ChangeMemberVotingStatesForAllShardsInputBuilder setMemberVotingState(final List<MemberVotingState> values) {
        this._memberVotingState = values;
        return this;
    }
    
    
    public ChangeMemberVotingStatesForAllShardsInputBuilder addAugmentation(Class<? extends Augmentation<ChangeMemberVotingStatesForAllShardsInput>> augmentationType, Augmentation<ChangeMemberVotingStatesForAllShardsInput> augmentationValue) {
        if (augmentationValue == null) {
            return removeAugmentation(augmentationType);
        }
    
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }
    
    public ChangeMemberVotingStatesForAllShardsInputBuilder removeAugmentation(Class<? extends Augmentation<ChangeMemberVotingStatesForAllShardsInput>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public ChangeMemberVotingStatesForAllShardsInput build() {
        return new ChangeMemberVotingStatesForAllShardsInputImpl(this);
    }

    private static final class ChangeMemberVotingStatesForAllShardsInputImpl implements ChangeMemberVotingStatesForAllShardsInput {
    
        private final List<MemberVotingState> _memberVotingState;
    
        private Map<Class<? extends Augmentation<ChangeMemberVotingStatesForAllShardsInput>>, Augmentation<ChangeMemberVotingStatesForAllShardsInput>> augmentation = Collections.emptyMap();
    
        ChangeMemberVotingStatesForAllShardsInputImpl(ChangeMemberVotingStatesForAllShardsInputBuilder base) {
            this._memberVotingState = base.getMemberVotingState();
            this.augmentation = ImmutableMap.copyOf(base.augmentation);
        }
    
        @Override
        public Class<ChangeMemberVotingStatesForAllShardsInput> getImplementedInterface() {
            return ChangeMemberVotingStatesForAllShardsInput.class;
        }
    
        @Override
        public List<MemberVotingState> getMemberVotingState() {
            return _memberVotingState;
        }
        
        @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
        @Override
        public <E$$ extends Augmentation<ChangeMemberVotingStatesForAllShardsInput>> E$$ augmentation(Class<E$$> augmentationType) {
            return (E$$) augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int prime = 31;
            int result = 1;
            result = prime * result + Objects.hashCode(_memberVotingState);
            result = prime * result + Objects.hashCode(augmentation);
        
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!ChangeMemberVotingStatesForAllShardsInput.class.equals(((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            ChangeMemberVotingStatesForAllShardsInput other = (ChangeMemberVotingStatesForAllShardsInput)obj;
            if (!Objects.equals(_memberVotingState, other.getMemberVotingState())) {
                return false;
            }
            if (getClass() == obj.getClass()) {
                // Simple case: we are comparing against self
                ChangeMemberVotingStatesForAllShardsInputImpl otherImpl = (ChangeMemberVotingStatesForAllShardsInputImpl) obj;
                if (!Objects.equals(augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                // Hard case: compare our augments with presence there...
                for (Map.Entry<Class<? extends Augmentation<ChangeMemberVotingStatesForAllShardsInput>>, Augmentation<ChangeMemberVotingStatesForAllShardsInput>> e : augmentation.entrySet()) {
                    if (!e.getValue().equals(other.augmentation(e.getKey()))) {
                        return false;
                    }
                }
                // .. and give the other one the chance to do the same
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }
    
        @Override
        public String toString() {
            final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("ChangeMemberVotingStatesForAllShardsInput");
            CodeHelpers.appendValue(helper, "_memberVotingState", _memberVotingState);
            CodeHelpers.appendValue(helper, "augmentation", augmentation.values());
            return helper.toString();
        }
    }
}
