package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.cluster.admin.rev151013;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.lang.Class;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.cluster.admin.rev151013.member.voting.states.input.MemberVotingState;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link ChangeMemberVotingStatesForShardInputBuilder} instances.
 *
 * @see ChangeMemberVotingStatesForShardInputBuilder
 *
 */
public class ChangeMemberVotingStatesForShardInputBuilder implements Builder<ChangeMemberVotingStatesForShardInput> {

    private DataStoreType _dataStoreType;
    private List<MemberVotingState> _memberVotingState;
    private String _shardName;


    Map<Class<? extends Augmentation<ChangeMemberVotingStatesForShardInput>>, Augmentation<ChangeMemberVotingStatesForShardInput>> augmentation = Collections.emptyMap();

    public ChangeMemberVotingStatesForShardInputBuilder() {
    }
    public ChangeMemberVotingStatesForShardInputBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.cluster.admin.rev151013.MemberVotingStatesInput arg) {
        this._memberVotingState = arg.getMemberVotingState();
    }

    public ChangeMemberVotingStatesForShardInputBuilder(ChangeMemberVotingStatesForShardInput base) {
        this._dataStoreType = base.getDataStoreType();
        this._memberVotingState = base.getMemberVotingState();
        this._shardName = base.getShardName();
        if (base instanceof ChangeMemberVotingStatesForShardInputImpl) {
            ChangeMemberVotingStatesForShardInputImpl impl = (ChangeMemberVotingStatesForShardInputImpl) base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder) {
            @SuppressWarnings("unchecked")
            Map<Class<? extends Augmentation<ChangeMemberVotingStatesForShardInput>>, Augmentation<ChangeMemberVotingStatesForShardInput>> aug =((AugmentationHolder<ChangeMemberVotingStatesForShardInput>) base).augmentations();
            if (!aug.isEmpty()) {
                this.augmentation = new HashMap<>(aug);
            }
        }
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.cluster.admin.rev151013.MemberVotingStatesInput</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.cluster.admin.rev151013.MemberVotingStatesInput) {
            this._memberVotingState = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.cluster.admin.rev151013.MemberVotingStatesInput)arg).getMemberVotingState();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.cluster.admin.rev151013.MemberVotingStatesInput]");
    }

    public DataStoreType getDataStoreType() {
        return _dataStoreType;
    }
    
    public List<MemberVotingState> getMemberVotingState() {
        return _memberVotingState;
    }
    
    public String getShardName() {
        return _shardName;
    }
    
    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<ChangeMemberVotingStatesForShardInput>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
    }

    
    public ChangeMemberVotingStatesForShardInputBuilder setDataStoreType(final DataStoreType value) {
        this._dataStoreType = value;
        return this;
    }
    public ChangeMemberVotingStatesForShardInputBuilder setMemberVotingState(final List<MemberVotingState> values) {
        this._memberVotingState = values;
        return this;
    }
    
    
    public ChangeMemberVotingStatesForShardInputBuilder setShardName(final String value) {
        this._shardName = value;
        return this;
    }
    
    public ChangeMemberVotingStatesForShardInputBuilder addAugmentation(Class<? extends Augmentation<ChangeMemberVotingStatesForShardInput>> augmentationType, Augmentation<ChangeMemberVotingStatesForShardInput> augmentationValue) {
        if (augmentationValue == null) {
            return removeAugmentation(augmentationType);
        }
    
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }
    
    public ChangeMemberVotingStatesForShardInputBuilder removeAugmentation(Class<? extends Augmentation<ChangeMemberVotingStatesForShardInput>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public ChangeMemberVotingStatesForShardInput build() {
        return new ChangeMemberVotingStatesForShardInputImpl(this);
    }

    private static final class ChangeMemberVotingStatesForShardInputImpl implements ChangeMemberVotingStatesForShardInput {
    
        private final DataStoreType _dataStoreType;
        private final List<MemberVotingState> _memberVotingState;
        private final String _shardName;
    
        private Map<Class<? extends Augmentation<ChangeMemberVotingStatesForShardInput>>, Augmentation<ChangeMemberVotingStatesForShardInput>> augmentation = Collections.emptyMap();
    
        ChangeMemberVotingStatesForShardInputImpl(ChangeMemberVotingStatesForShardInputBuilder base) {
            this._dataStoreType = base.getDataStoreType();
            this._memberVotingState = base.getMemberVotingState();
            this._shardName = base.getShardName();
            this.augmentation = ImmutableMap.copyOf(base.augmentation);
        }
    
        @Override
        public Class<ChangeMemberVotingStatesForShardInput> getImplementedInterface() {
            return ChangeMemberVotingStatesForShardInput.class;
        }
    
        @Override
        public DataStoreType getDataStoreType() {
            return _dataStoreType;
        }
        
        @Override
        public List<MemberVotingState> getMemberVotingState() {
            return _memberVotingState;
        }
        
        @Override
        public String getShardName() {
            return _shardName;
        }
        
        @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
        @Override
        public <E$$ extends Augmentation<ChangeMemberVotingStatesForShardInput>> E$$ augmentation(Class<E$$> augmentationType) {
            return (E$$) augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int prime = 31;
            int result = 1;
            result = prime * result + Objects.hashCode(_dataStoreType);
            result = prime * result + Objects.hashCode(_memberVotingState);
            result = prime * result + Objects.hashCode(_shardName);
            result = prime * result + Objects.hashCode(augmentation);
        
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!ChangeMemberVotingStatesForShardInput.class.equals(((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            ChangeMemberVotingStatesForShardInput other = (ChangeMemberVotingStatesForShardInput)obj;
            if (!Objects.equals(_dataStoreType, other.getDataStoreType())) {
                return false;
            }
            if (!Objects.equals(_memberVotingState, other.getMemberVotingState())) {
                return false;
            }
            if (!Objects.equals(_shardName, other.getShardName())) {
                return false;
            }
            if (getClass() == obj.getClass()) {
                // Simple case: we are comparing against self
                ChangeMemberVotingStatesForShardInputImpl otherImpl = (ChangeMemberVotingStatesForShardInputImpl) obj;
                if (!Objects.equals(augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                // Hard case: compare our augments with presence there...
                for (Map.Entry<Class<? extends Augmentation<ChangeMemberVotingStatesForShardInput>>, Augmentation<ChangeMemberVotingStatesForShardInput>> e : augmentation.entrySet()) {
                    if (!e.getValue().equals(other.augmentation(e.getKey()))) {
                        return false;
                    }
                }
                // .. and give the other one the chance to do the same
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }
    
        @Override
        public String toString() {
            final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("ChangeMemberVotingStatesForShardInput");
            CodeHelpers.appendValue(helper, "_dataStoreType", _dataStoreType);
            CodeHelpers.appendValue(helper, "_memberVotingState", _memberVotingState);
            CodeHelpers.appendValue(helper, "_shardName", _shardName);
            CodeHelpers.appendValue(helper, "augmentation", augmentation.values());
            return helper.toString();
        }
    }
}
