package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.cluster.admin.rev151013;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.lang.Class;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link ChangeMemberVotingStatesForShardOutputBuilder} instances.
 *
 * @see ChangeMemberVotingStatesForShardOutputBuilder
 *
 */
public class ChangeMemberVotingStatesForShardOutputBuilder implements Builder<ChangeMemberVotingStatesForShardOutput> {



    Map<Class<? extends Augmentation<ChangeMemberVotingStatesForShardOutput>>, Augmentation<ChangeMemberVotingStatesForShardOutput>> augmentation = Collections.emptyMap();

    public ChangeMemberVotingStatesForShardOutputBuilder() {
    }

    public ChangeMemberVotingStatesForShardOutputBuilder(ChangeMemberVotingStatesForShardOutput base) {
        if (base instanceof ChangeMemberVotingStatesForShardOutputImpl) {
            ChangeMemberVotingStatesForShardOutputImpl impl = (ChangeMemberVotingStatesForShardOutputImpl) base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder) {
            @SuppressWarnings("unchecked")
            Map<Class<? extends Augmentation<ChangeMemberVotingStatesForShardOutput>>, Augmentation<ChangeMemberVotingStatesForShardOutput>> aug =((AugmentationHolder<ChangeMemberVotingStatesForShardOutput>) base).augmentations();
            if (!aug.isEmpty()) {
                this.augmentation = new HashMap<>(aug);
            }
        }
    }


    
    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<ChangeMemberVotingStatesForShardOutput>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
    }

    
    public ChangeMemberVotingStatesForShardOutputBuilder addAugmentation(Class<? extends Augmentation<ChangeMemberVotingStatesForShardOutput>> augmentationType, Augmentation<ChangeMemberVotingStatesForShardOutput> augmentationValue) {
        if (augmentationValue == null) {
            return removeAugmentation(augmentationType);
        }
    
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }
    
    public ChangeMemberVotingStatesForShardOutputBuilder removeAugmentation(Class<? extends Augmentation<ChangeMemberVotingStatesForShardOutput>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public ChangeMemberVotingStatesForShardOutput build() {
        return new ChangeMemberVotingStatesForShardOutputImpl(this);
    }

    private static final class ChangeMemberVotingStatesForShardOutputImpl implements ChangeMemberVotingStatesForShardOutput {
    
    
        private Map<Class<? extends Augmentation<ChangeMemberVotingStatesForShardOutput>>, Augmentation<ChangeMemberVotingStatesForShardOutput>> augmentation = Collections.emptyMap();
    
        ChangeMemberVotingStatesForShardOutputImpl(ChangeMemberVotingStatesForShardOutputBuilder base) {
            this.augmentation = ImmutableMap.copyOf(base.augmentation);
        }
    
        @Override
        public Class<ChangeMemberVotingStatesForShardOutput> getImplementedInterface() {
            return ChangeMemberVotingStatesForShardOutput.class;
        }
    
        
        @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
        @Override
        public <E$$ extends Augmentation<ChangeMemberVotingStatesForShardOutput>> E$$ augmentation(Class<E$$> augmentationType) {
            return (E$$) augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int prime = 31;
            int result = 1;
            result = prime * result + Objects.hashCode(augmentation);
        
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!ChangeMemberVotingStatesForShardOutput.class.equals(((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            ChangeMemberVotingStatesForShardOutput other = (ChangeMemberVotingStatesForShardOutput)obj;
            if (getClass() == obj.getClass()) {
                // Simple case: we are comparing against self
                ChangeMemberVotingStatesForShardOutputImpl otherImpl = (ChangeMemberVotingStatesForShardOutputImpl) obj;
                if (!Objects.equals(augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                // Hard case: compare our augments with presence there...
                for (Map.Entry<Class<? extends Augmentation<ChangeMemberVotingStatesForShardOutput>>, Augmentation<ChangeMemberVotingStatesForShardOutput>> e : augmentation.entrySet()) {
                    if (!e.getValue().equals(other.augmentation(e.getKey()))) {
                        return false;
                    }
                }
                // .. and give the other one the chance to do the same
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }
    
        @Override
        public String toString() {
            final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("ChangeMemberVotingStatesForShardOutput");
            CodeHelpers.appendValue(helper, "augmentation", augmentation.values());
            return helper.toString();
        }
    }
}
