package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.cluster.admin.rev151013;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.lang.Class;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link FlipMemberVotingStatesForAllShardsInputBuilder} instances.
 *
 * @see FlipMemberVotingStatesForAllShardsInputBuilder
 *
 */
public class FlipMemberVotingStatesForAllShardsInputBuilder implements Builder<FlipMemberVotingStatesForAllShardsInput> {



    Map<Class<? extends Augmentation<FlipMemberVotingStatesForAllShardsInput>>, Augmentation<FlipMemberVotingStatesForAllShardsInput>> augmentation = Collections.emptyMap();

    public FlipMemberVotingStatesForAllShardsInputBuilder() {
    }

    public FlipMemberVotingStatesForAllShardsInputBuilder(FlipMemberVotingStatesForAllShardsInput base) {
        if (base instanceof FlipMemberVotingStatesForAllShardsInputImpl) {
            FlipMemberVotingStatesForAllShardsInputImpl impl = (FlipMemberVotingStatesForAllShardsInputImpl) base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder) {
            @SuppressWarnings("unchecked")
            Map<Class<? extends Augmentation<FlipMemberVotingStatesForAllShardsInput>>, Augmentation<FlipMemberVotingStatesForAllShardsInput>> aug =((AugmentationHolder<FlipMemberVotingStatesForAllShardsInput>) base).augmentations();
            if (!aug.isEmpty()) {
                this.augmentation = new HashMap<>(aug);
            }
        }
    }


    
    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<FlipMemberVotingStatesForAllShardsInput>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
    }

    
    public FlipMemberVotingStatesForAllShardsInputBuilder addAugmentation(Class<? extends Augmentation<FlipMemberVotingStatesForAllShardsInput>> augmentationType, Augmentation<FlipMemberVotingStatesForAllShardsInput> augmentationValue) {
        if (augmentationValue == null) {
            return removeAugmentation(augmentationType);
        }
    
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }
    
    public FlipMemberVotingStatesForAllShardsInputBuilder removeAugmentation(Class<? extends Augmentation<FlipMemberVotingStatesForAllShardsInput>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public FlipMemberVotingStatesForAllShardsInput build() {
        return new FlipMemberVotingStatesForAllShardsInputImpl(this);
    }

    private static final class FlipMemberVotingStatesForAllShardsInputImpl implements FlipMemberVotingStatesForAllShardsInput {
    
    
        private Map<Class<? extends Augmentation<FlipMemberVotingStatesForAllShardsInput>>, Augmentation<FlipMemberVotingStatesForAllShardsInput>> augmentation = Collections.emptyMap();
    
        FlipMemberVotingStatesForAllShardsInputImpl(FlipMemberVotingStatesForAllShardsInputBuilder base) {
            this.augmentation = ImmutableMap.copyOf(base.augmentation);
        }
    
        @Override
        public Class<FlipMemberVotingStatesForAllShardsInput> getImplementedInterface() {
            return FlipMemberVotingStatesForAllShardsInput.class;
        }
    
        
        @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
        @Override
        public <E$$ extends Augmentation<FlipMemberVotingStatesForAllShardsInput>> E$$ augmentation(Class<E$$> augmentationType) {
            return (E$$) augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int prime = 31;
            int result = 1;
            result = prime * result + Objects.hashCode(augmentation);
        
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!FlipMemberVotingStatesForAllShardsInput.class.equals(((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            FlipMemberVotingStatesForAllShardsInput other = (FlipMemberVotingStatesForAllShardsInput)obj;
            if (getClass() == obj.getClass()) {
                // Simple case: we are comparing against self
                FlipMemberVotingStatesForAllShardsInputImpl otherImpl = (FlipMemberVotingStatesForAllShardsInputImpl) obj;
                if (!Objects.equals(augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                // Hard case: compare our augments with presence there...
                for (Map.Entry<Class<? extends Augmentation<FlipMemberVotingStatesForAllShardsInput>>, Augmentation<FlipMemberVotingStatesForAllShardsInput>> e : augmentation.entrySet()) {
                    if (!e.getValue().equals(other.augmentation(e.getKey()))) {
                        return false;
                    }
                }
                // .. and give the other one the chance to do the same
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }
    
        @Override
        public String toString() {
            final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("FlipMemberVotingStatesForAllShardsInput");
            CodeHelpers.appendValue(helper, "augmentation", augmentation.values());
            return helper.toString();
        }
    }
}
