package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.cluster.admin.rev151013;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.lang.Class;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;

/**
 * Class that builds {@link GetPrefixShardRoleInputBuilder} instances.
 *
 * @see GetPrefixShardRoleInputBuilder
 *
 */
public class GetPrefixShardRoleInputBuilder implements Builder<GetPrefixShardRoleInput> {

    private DataStoreType _dataStoreType;
    private InstanceIdentifier<?> _shardPrefix;


    Map<Class<? extends Augmentation<GetPrefixShardRoleInput>>, Augmentation<GetPrefixShardRoleInput>> augmentation = Collections.emptyMap();

    public GetPrefixShardRoleInputBuilder() {
    }

    public GetPrefixShardRoleInputBuilder(GetPrefixShardRoleInput base) {
        this._dataStoreType = base.getDataStoreType();
        this._shardPrefix = base.getShardPrefix();
        if (base instanceof GetPrefixShardRoleInputImpl) {
            GetPrefixShardRoleInputImpl impl = (GetPrefixShardRoleInputImpl) base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder) {
            @SuppressWarnings("unchecked")
            Map<Class<? extends Augmentation<GetPrefixShardRoleInput>>, Augmentation<GetPrefixShardRoleInput>> aug =((AugmentationHolder<GetPrefixShardRoleInput>) base).augmentations();
            if (!aug.isEmpty()) {
                this.augmentation = new HashMap<>(aug);
            }
        }
    }


    public DataStoreType getDataStoreType() {
        return _dataStoreType;
    }
    
    public InstanceIdentifier<?> getShardPrefix() {
        return _shardPrefix;
    }
    
    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<GetPrefixShardRoleInput>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
    }

    
    public GetPrefixShardRoleInputBuilder setDataStoreType(final DataStoreType value) {
        this._dataStoreType = value;
        return this;
    }
    
    public GetPrefixShardRoleInputBuilder setShardPrefix(final InstanceIdentifier<?> value) {
        this._shardPrefix = value;
        return this;
    }
    
    public GetPrefixShardRoleInputBuilder addAugmentation(Class<? extends Augmentation<GetPrefixShardRoleInput>> augmentationType, Augmentation<GetPrefixShardRoleInput> augmentationValue) {
        if (augmentationValue == null) {
            return removeAugmentation(augmentationType);
        }
    
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }
    
    public GetPrefixShardRoleInputBuilder removeAugmentation(Class<? extends Augmentation<GetPrefixShardRoleInput>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public GetPrefixShardRoleInput build() {
        return new GetPrefixShardRoleInputImpl(this);
    }

    private static final class GetPrefixShardRoleInputImpl implements GetPrefixShardRoleInput {
    
        private final DataStoreType _dataStoreType;
        private final InstanceIdentifier<?> _shardPrefix;
    
        private Map<Class<? extends Augmentation<GetPrefixShardRoleInput>>, Augmentation<GetPrefixShardRoleInput>> augmentation = Collections.emptyMap();
    
        GetPrefixShardRoleInputImpl(GetPrefixShardRoleInputBuilder base) {
            this._dataStoreType = base.getDataStoreType();
            this._shardPrefix = base.getShardPrefix();
            this.augmentation = ImmutableMap.copyOf(base.augmentation);
        }
    
        @Override
        public Class<GetPrefixShardRoleInput> getImplementedInterface() {
            return GetPrefixShardRoleInput.class;
        }
    
        @Override
        public DataStoreType getDataStoreType() {
            return _dataStoreType;
        }
        
        @Override
        public InstanceIdentifier<?> getShardPrefix() {
            return _shardPrefix;
        }
        
        @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
        @Override
        public <E$$ extends Augmentation<GetPrefixShardRoleInput>> E$$ augmentation(Class<E$$> augmentationType) {
            return (E$$) augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int prime = 31;
            int result = 1;
            result = prime * result + Objects.hashCode(_dataStoreType);
            result = prime * result + Objects.hashCode(_shardPrefix);
            result = prime * result + Objects.hashCode(augmentation);
        
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!GetPrefixShardRoleInput.class.equals(((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            GetPrefixShardRoleInput other = (GetPrefixShardRoleInput)obj;
            if (!Objects.equals(_dataStoreType, other.getDataStoreType())) {
                return false;
            }
            if (!Objects.equals(_shardPrefix, other.getShardPrefix())) {
                return false;
            }
            if (getClass() == obj.getClass()) {
                // Simple case: we are comparing against self
                GetPrefixShardRoleInputImpl otherImpl = (GetPrefixShardRoleInputImpl) obj;
                if (!Objects.equals(augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                // Hard case: compare our augments with presence there...
                for (Map.Entry<Class<? extends Augmentation<GetPrefixShardRoleInput>>, Augmentation<GetPrefixShardRoleInput>> e : augmentation.entrySet()) {
                    if (!e.getValue().equals(other.augmentation(e.getKey()))) {
                        return false;
                    }
                }
                // .. and give the other one the chance to do the same
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }
    
        @Override
        public String toString() {
            final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("GetPrefixShardRoleInput");
            CodeHelpers.appendValue(helper, "_dataStoreType", _dataStoreType);
            CodeHelpers.appendValue(helper, "_shardPrefix", _shardPrefix);
            CodeHelpers.appendValue(helper, "augmentation", augmentation.values());
            return helper.toString();
        }
    }
}
