package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.cluster.admin.rev151013;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.lang.Class;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link GetPrefixShardRoleOutputBuilder} instances.
 *
 * @see GetPrefixShardRoleOutputBuilder
 *
 */
public class GetPrefixShardRoleOutputBuilder implements Builder<GetPrefixShardRoleOutput> {

    private String _role;


    Map<Class<? extends Augmentation<GetPrefixShardRoleOutput>>, Augmentation<GetPrefixShardRoleOutput>> augmentation = Collections.emptyMap();

    public GetPrefixShardRoleOutputBuilder() {
    }

    public GetPrefixShardRoleOutputBuilder(GetPrefixShardRoleOutput base) {
        this._role = base.getRole();
        if (base instanceof GetPrefixShardRoleOutputImpl) {
            GetPrefixShardRoleOutputImpl impl = (GetPrefixShardRoleOutputImpl) base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder) {
            @SuppressWarnings("unchecked")
            Map<Class<? extends Augmentation<GetPrefixShardRoleOutput>>, Augmentation<GetPrefixShardRoleOutput>> aug =((AugmentationHolder<GetPrefixShardRoleOutput>) base).augmentations();
            if (!aug.isEmpty()) {
                this.augmentation = new HashMap<>(aug);
            }
        }
    }


    public String getRole() {
        return _role;
    }
    
    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<GetPrefixShardRoleOutput>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
    }

    
    public GetPrefixShardRoleOutputBuilder setRole(final String value) {
        this._role = value;
        return this;
    }
    
    public GetPrefixShardRoleOutputBuilder addAugmentation(Class<? extends Augmentation<GetPrefixShardRoleOutput>> augmentationType, Augmentation<GetPrefixShardRoleOutput> augmentationValue) {
        if (augmentationValue == null) {
            return removeAugmentation(augmentationType);
        }
    
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }
    
    public GetPrefixShardRoleOutputBuilder removeAugmentation(Class<? extends Augmentation<GetPrefixShardRoleOutput>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public GetPrefixShardRoleOutput build() {
        return new GetPrefixShardRoleOutputImpl(this);
    }

    private static final class GetPrefixShardRoleOutputImpl implements GetPrefixShardRoleOutput {
    
        private final String _role;
    
        private Map<Class<? extends Augmentation<GetPrefixShardRoleOutput>>, Augmentation<GetPrefixShardRoleOutput>> augmentation = Collections.emptyMap();
    
        GetPrefixShardRoleOutputImpl(GetPrefixShardRoleOutputBuilder base) {
            this._role = base.getRole();
            this.augmentation = ImmutableMap.copyOf(base.augmentation);
        }
    
        @Override
        public Class<GetPrefixShardRoleOutput> getImplementedInterface() {
            return GetPrefixShardRoleOutput.class;
        }
    
        @Override
        public String getRole() {
            return _role;
        }
        
        @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
        @Override
        public <E$$ extends Augmentation<GetPrefixShardRoleOutput>> E$$ augmentation(Class<E$$> augmentationType) {
            return (E$$) augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int prime = 31;
            int result = 1;
            result = prime * result + Objects.hashCode(_role);
            result = prime * result + Objects.hashCode(augmentation);
        
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!GetPrefixShardRoleOutput.class.equals(((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            GetPrefixShardRoleOutput other = (GetPrefixShardRoleOutput)obj;
            if (!Objects.equals(_role, other.getRole())) {
                return false;
            }
            if (getClass() == obj.getClass()) {
                // Simple case: we are comparing against self
                GetPrefixShardRoleOutputImpl otherImpl = (GetPrefixShardRoleOutputImpl) obj;
                if (!Objects.equals(augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                // Hard case: compare our augments with presence there...
                for (Map.Entry<Class<? extends Augmentation<GetPrefixShardRoleOutput>>, Augmentation<GetPrefixShardRoleOutput>> e : augmentation.entrySet()) {
                    if (!e.getValue().equals(other.augmentation(e.getKey()))) {
                        return false;
                    }
                }
                // .. and give the other one the chance to do the same
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }
    
        @Override
        public String toString() {
            final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("GetPrefixShardRoleOutput");
            CodeHelpers.appendValue(helper, "_role", _role);
            CodeHelpers.appendValue(helper, "augmentation", augmentation.values());
            return helper.toString();
        }
    }
}
